/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sns.model.Subscription;

public class SubscriptionUnmarshaller
implements Unmarshaller<Subscription, StaxUnmarshallerContext> {
    private static final SubscriptionUnmarshaller INSTANCE = new SubscriptionUnmarshaller();

    public Subscription unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Subscription.Builder subscription = Subscription.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SubscriptionArn", targetDepth)) {
                    subscription.subscriptionArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Owner", targetDepth)) {
                    subscription.owner(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Protocol", targetDepth)) {
                    subscription.protocol(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Endpoint", targetDepth)) {
                    subscription.endpoint(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("TopicArn", targetDepth)) continue;
                subscription.topicArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Subscription)subscription.build();
    }

    public static SubscriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

