/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.MapEntry;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sns.model.Endpoint;

public class EndpointUnmarshaller
implements Unmarshaller<Endpoint, StaxUnmarshallerContext> {
    private static final EndpointUnmarshaller INSTANCE = new EndpointUnmarshaller();

    public Endpoint unmarshall(StaxUnmarshallerContext context) throws Exception {
        Endpoint.Builder endpoint;
        block6: {
            endpoint = Endpoint.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            HashMap<String, String> attributes = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    endpoint.attributes(attributes);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("EndpointArn", targetDepth)) {
                        endpoint.endpointArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Attributes/entry", targetDepth)) continue;
                    if (attributes == null) {
                        attributes = new HashMap<String, String>();
                    }
                    Map.Entry<String, String> entry = AttributesMapEntryUnmarshaller.getInstance().unmarshall(context);
                    attributes.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            endpoint.attributes(attributes);
        }
        return (Endpoint)endpoint.build();
    }

    public static EndpointUnmarshaller getInstance() {
        return INSTANCE;
    }

    private static class AttributesMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {
        private static final AttributesMapEntryUnmarshaller INSTANCE = new AttributesMapEntryUnmarshaller();

        private AttributesMapEntryUnmarshaller() {
        }

        public Map.Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry entry = new MapEntry();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey((Object)SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("value", targetDepth)) continue;
                    entry.setValue((Object)SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static AttributesMapEntryUnmarshaller getInstance() {
            return INSTANCE;
        }
    }
}

