/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.sns.SNSClient;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicResponse;
import software.amazon.awssdk.services.sns.model.Subscription;

public final class ListSubscriptionsByTopicPaginator
implements SdkIterable<ListSubscriptionsByTopicResponse> {
    private final SNSClient client;
    private final ListSubscriptionsByTopicRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListSubscriptionsByTopicPaginator(SNSClient client, ListSubscriptionsByTopicRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSubscriptionsByTopicResponseFetcher();
    }

    public Iterator<ListSubscriptionsByTopicResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Subscription> subscriptions() {
        Function<ListSubscriptionsByTopicResponse, Iterator> getIterator = response -> response != null ? response.subscriptions().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListSubscriptionsByTopicResponseFetcher
    implements NextPageFetcher<ListSubscriptionsByTopicResponse> {
        private ListSubscriptionsByTopicResponseFetcher() {
        }

        public boolean hasNextPage(ListSubscriptionsByTopicResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListSubscriptionsByTopicResponse nextPage(ListSubscriptionsByTopicResponse previousPage) {
            if (previousPage == null) {
                return ListSubscriptionsByTopicPaginator.this.client.listSubscriptionsByTopic(ListSubscriptionsByTopicPaginator.this.firstRequest);
            }
            return ListSubscriptionsByTopicPaginator.this.client.listSubscriptionsByTopic((ListSubscriptionsByTopicRequest)((Object)ListSubscriptionsByTopicPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

