/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.AmazonServiceException;
import software.amazon.awssdk.core.SdkBaseException;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.ClientHandler;
import software.amazon.awssdk.core.client.SdkClientHandler;
import software.amazon.awssdk.core.config.ClientConfiguration;
import software.amazon.awssdk.core.config.SyncClientConfiguration;
import software.amazon.awssdk.core.http.DefaultErrorResponseHandler;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.StaxResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.StandardErrorUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sns.SNSClient;
import software.amazon.awssdk.services.sns.model.AddPermissionRequest;
import software.amazon.awssdk.services.sns.model.AddPermissionResponse;
import software.amazon.awssdk.services.sns.model.AuthorizationErrorException;
import software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutRequest;
import software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutResponse;
import software.amazon.awssdk.services.sns.model.ConfirmSubscriptionRequest;
import software.amazon.awssdk.services.sns.model.ConfirmSubscriptionResponse;
import software.amazon.awssdk.services.sns.model.CreatePlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.CreatePlatformApplicationResponse;
import software.amazon.awssdk.services.sns.model.CreatePlatformEndpointRequest;
import software.amazon.awssdk.services.sns.model.CreatePlatformEndpointResponse;
import software.amazon.awssdk.services.sns.model.CreateTopicRequest;
import software.amazon.awssdk.services.sns.model.CreateTopicResponse;
import software.amazon.awssdk.services.sns.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.sns.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.sns.model.DeletePlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.DeletePlatformApplicationResponse;
import software.amazon.awssdk.services.sns.model.DeleteTopicRequest;
import software.amazon.awssdk.services.sns.model.DeleteTopicResponse;
import software.amazon.awssdk.services.sns.model.EndpointDisabledException;
import software.amazon.awssdk.services.sns.model.GetEndpointAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetEndpointAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetSMSAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetSMSAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetTopicAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetTopicAttributesResponse;
import software.amazon.awssdk.services.sns.model.InternalErrorException;
import software.amazon.awssdk.services.sns.model.InvalidParameterException;
import software.amazon.awssdk.services.sns.model.InvalidParameterValueException;
import software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationResponse;
import software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest;
import software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutResponse;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicResponse;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsResponse;
import software.amazon.awssdk.services.sns.model.ListTopicsRequest;
import software.amazon.awssdk.services.sns.model.ListTopicsResponse;
import software.amazon.awssdk.services.sns.model.NotFoundException;
import software.amazon.awssdk.services.sns.model.OptInPhoneNumberRequest;
import software.amazon.awssdk.services.sns.model.OptInPhoneNumberResponse;
import software.amazon.awssdk.services.sns.model.PlatformApplicationDisabledException;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.PublishResponse;
import software.amazon.awssdk.services.sns.model.RemovePermissionRequest;
import software.amazon.awssdk.services.sns.model.RemovePermissionResponse;
import software.amazon.awssdk.services.sns.model.SNSException;
import software.amazon.awssdk.services.sns.model.SetEndpointAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetEndpointAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetPlatformApplicationAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetPlatformApplicationAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetSMSAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetSMSAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetSubscriptionAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetSubscriptionAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetTopicAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetTopicAttributesResponse;
import software.amazon.awssdk.services.sns.model.SubscribeRequest;
import software.amazon.awssdk.services.sns.model.SubscribeResponse;
import software.amazon.awssdk.services.sns.model.SubscriptionLimitExceededException;
import software.amazon.awssdk.services.sns.model.ThrottledException;
import software.amazon.awssdk.services.sns.model.TopicLimitExceededException;
import software.amazon.awssdk.services.sns.model.UnsubscribeRequest;
import software.amazon.awssdk.services.sns.model.UnsubscribeResponse;
import software.amazon.awssdk.services.sns.paginators.ListEndpointsByPlatformApplicationPaginator;
import software.amazon.awssdk.services.sns.paginators.ListPlatformApplicationsPaginator;
import software.amazon.awssdk.services.sns.paginators.ListSubscriptionsByTopicPaginator;
import software.amazon.awssdk.services.sns.paginators.ListSubscriptionsPaginator;
import software.amazon.awssdk.services.sns.paginators.ListTopicsPaginator;
import software.amazon.awssdk.services.sns.transform.AddPermissionRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.AddPermissionResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.AuthorizationErrorExceptionUnmarshaller;
import software.amazon.awssdk.services.sns.transform.CheckIfPhoneNumberIsOptedOutRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.CheckIfPhoneNumberIsOptedOutResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.ConfirmSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ConfirmSubscriptionResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.CreatePlatformApplicationRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.CreatePlatformApplicationResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.CreatePlatformEndpointRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.CreatePlatformEndpointResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.CreateTopicRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.CreateTopicResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.DeleteEndpointRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.DeleteEndpointResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.DeletePlatformApplicationRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.DeletePlatformApplicationResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.DeleteTopicRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.DeleteTopicResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.EndpointDisabledExceptionUnmarshaller;
import software.amazon.awssdk.services.sns.transform.GetEndpointAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.GetEndpointAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.GetPlatformApplicationAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.GetPlatformApplicationAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.GetSMSAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.GetSMSAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.GetSubscriptionAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.GetSubscriptionAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.GetTopicAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.GetTopicAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.InternalErrorExceptionUnmarshaller;
import software.amazon.awssdk.services.sns.transform.InvalidParameterExceptionUnmarshaller;
import software.amazon.awssdk.services.sns.transform.InvalidParameterValueExceptionUnmarshaller;
import software.amazon.awssdk.services.sns.transform.ListEndpointsByPlatformApplicationRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListEndpointsByPlatformApplicationResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.ListPhoneNumbersOptedOutRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListPhoneNumbersOptedOutResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.ListPlatformApplicationsRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListPlatformApplicationsResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.ListSubscriptionsByTopicRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListSubscriptionsByTopicResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.ListSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListSubscriptionsResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.ListTopicsRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListTopicsResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.NotFoundExceptionUnmarshaller;
import software.amazon.awssdk.services.sns.transform.OptInPhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.OptInPhoneNumberResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.PlatformApplicationDisabledExceptionUnmarshaller;
import software.amazon.awssdk.services.sns.transform.PublishRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.PublishResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.RemovePermissionRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.RemovePermissionResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.SetEndpointAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SetEndpointAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.SetPlatformApplicationAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SetPlatformApplicationAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.SetSMSAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SetSMSAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.SetSubscriptionAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SetSubscriptionAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.SetTopicAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SetTopicAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.SubscribeRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SubscribeResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.SubscriptionLimitExceededExceptionUnmarshaller;
import software.amazon.awssdk.services.sns.transform.ThrottledExceptionUnmarshaller;
import software.amazon.awssdk.services.sns.transform.TopicLimitExceededExceptionUnmarshaller;
import software.amazon.awssdk.services.sns.transform.UnsubscribeRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.UnsubscribeResponseUnmarshaller;

@SdkInternalApi
final class DefaultSNSClient
implements SNSClient {
    private final ClientHandler clientHandler;
    private final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers;
    private final ClientConfiguration clientConfiguration;

    protected DefaultSNSClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.exceptionUnmarshallers = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    @Override
    public AddPermissionResponse addPermission(AddPermissionRequest addPermissionRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new AddPermissionResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (AddPermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)addPermissionRequest).withMarshaller((Marshaller)new AddPermissionRequestMarshaller()));
    }

    @Override
    public CheckIfPhoneNumberIsOptedOutResponse checkIfPhoneNumberIsOptedOut(CheckIfPhoneNumberIsOptedOutRequest checkIfPhoneNumberIsOptedOutRequest) throws ThrottledException, InternalErrorException, AuthorizationErrorException, InvalidParameterException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CheckIfPhoneNumberIsOptedOutResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (CheckIfPhoneNumberIsOptedOutResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)checkIfPhoneNumberIsOptedOutRequest).withMarshaller((Marshaller)new CheckIfPhoneNumberIsOptedOutRequestMarshaller()));
    }

    @Override
    public ConfirmSubscriptionResponse confirmSubscription(ConfirmSubscriptionRequest confirmSubscriptionRequest) throws SubscriptionLimitExceededException, InvalidParameterException, NotFoundException, InternalErrorException, AuthorizationErrorException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ConfirmSubscriptionResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ConfirmSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)confirmSubscriptionRequest).withMarshaller((Marshaller)new ConfirmSubscriptionRequestMarshaller()));
    }

    @Override
    public CreatePlatformApplicationResponse createPlatformApplication(CreatePlatformApplicationRequest createPlatformApplicationRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreatePlatformApplicationResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (CreatePlatformApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)createPlatformApplicationRequest).withMarshaller((Marshaller)new CreatePlatformApplicationRequestMarshaller()));
    }

    @Override
    public CreatePlatformEndpointResponse createPlatformEndpoint(CreatePlatformEndpointRequest createPlatformEndpointRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreatePlatformEndpointResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (CreatePlatformEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)createPlatformEndpointRequest).withMarshaller((Marshaller)new CreatePlatformEndpointRequestMarshaller()));
    }

    @Override
    public CreateTopicResponse createTopic(CreateTopicRequest createTopicRequest) throws InvalidParameterException, TopicLimitExceededException, InternalErrorException, AuthorizationErrorException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateTopicResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (CreateTopicResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)createTopicRequest).withMarshaller((Marshaller)new CreateTopicRequestMarshaller()));
    }

    @Override
    public DeleteEndpointResponse deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteEndpointResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DeleteEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deleteEndpointRequest).withMarshaller((Marshaller)new DeleteEndpointRequestMarshaller()));
    }

    @Override
    public DeletePlatformApplicationResponse deletePlatformApplication(DeletePlatformApplicationRequest deletePlatformApplicationRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeletePlatformApplicationResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DeletePlatformApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deletePlatformApplicationRequest).withMarshaller((Marshaller)new DeletePlatformApplicationRequestMarshaller()));
    }

    @Override
    public DeleteTopicResponse deleteTopic(DeleteTopicRequest deleteTopicRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteTopicResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DeleteTopicResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deleteTopicRequest).withMarshaller((Marshaller)new DeleteTopicRequestMarshaller()));
    }

    @Override
    public GetEndpointAttributesResponse getEndpointAttributes(GetEndpointAttributesRequest getEndpointAttributesRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetEndpointAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (GetEndpointAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getEndpointAttributesRequest).withMarshaller((Marshaller)new GetEndpointAttributesRequestMarshaller()));
    }

    @Override
    public GetPlatformApplicationAttributesResponse getPlatformApplicationAttributes(GetPlatformApplicationAttributesRequest getPlatformApplicationAttributesRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetPlatformApplicationAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (GetPlatformApplicationAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getPlatformApplicationAttributesRequest).withMarshaller((Marshaller)new GetPlatformApplicationAttributesRequestMarshaller()));
    }

    @Override
    public GetSMSAttributesResponse getSMSAttributes(GetSMSAttributesRequest getSMSAttributesRequest) throws ThrottledException, InternalErrorException, AuthorizationErrorException, InvalidParameterException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetSMSAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (GetSMSAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getSMSAttributesRequest).withMarshaller((Marshaller)new GetSMSAttributesRequestMarshaller()));
    }

    @Override
    public GetSubscriptionAttributesResponse getSubscriptionAttributes(GetSubscriptionAttributesRequest getSubscriptionAttributesRequest) throws InvalidParameterException, InternalErrorException, NotFoundException, AuthorizationErrorException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetSubscriptionAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (GetSubscriptionAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getSubscriptionAttributesRequest).withMarshaller((Marshaller)new GetSubscriptionAttributesRequestMarshaller()));
    }

    @Override
    public GetTopicAttributesResponse getTopicAttributes(GetTopicAttributesRequest getTopicAttributesRequest) throws InvalidParameterException, InternalErrorException, NotFoundException, AuthorizationErrorException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetTopicAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (GetTopicAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getTopicAttributesRequest).withMarshaller((Marshaller)new GetTopicAttributesRequestMarshaller()));
    }

    @Override
    public ListEndpointsByPlatformApplicationResponse listEndpointsByPlatformApplication(ListEndpointsByPlatformApplicationRequest listEndpointsByPlatformApplicationRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListEndpointsByPlatformApplicationResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListEndpointsByPlatformApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listEndpointsByPlatformApplicationRequest).withMarshaller((Marshaller)new ListEndpointsByPlatformApplicationRequestMarshaller()));
    }

    @Override
    public ListEndpointsByPlatformApplicationPaginator listEndpointsByPlatformApplicationIterable(ListEndpointsByPlatformApplicationRequest listEndpointsByPlatformApplicationRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, SdkBaseException, SdkClientException, SNSException {
        return new ListEndpointsByPlatformApplicationPaginator(this, listEndpointsByPlatformApplicationRequest);
    }

    @Override
    public ListPhoneNumbersOptedOutResponse listPhoneNumbersOptedOut(ListPhoneNumbersOptedOutRequest listPhoneNumbersOptedOutRequest) throws ThrottledException, InternalErrorException, AuthorizationErrorException, InvalidParameterException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListPhoneNumbersOptedOutResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListPhoneNumbersOptedOutResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listPhoneNumbersOptedOutRequest).withMarshaller((Marshaller)new ListPhoneNumbersOptedOutRequestMarshaller()));
    }

    @Override
    public ListPlatformApplicationsResponse listPlatformApplications(ListPlatformApplicationsRequest listPlatformApplicationsRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListPlatformApplicationsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListPlatformApplicationsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listPlatformApplicationsRequest).withMarshaller((Marshaller)new ListPlatformApplicationsRequestMarshaller()));
    }

    @Override
    public ListPlatformApplicationsPaginator listPlatformApplicationsIterable(ListPlatformApplicationsRequest listPlatformApplicationsRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, SdkBaseException, SdkClientException, SNSException {
        return new ListPlatformApplicationsPaginator(this, listPlatformApplicationsRequest);
    }

    @Override
    public ListSubscriptionsResponse listSubscriptions(ListSubscriptionsRequest listSubscriptionsRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListSubscriptionsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListSubscriptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listSubscriptionsRequest).withMarshaller((Marshaller)new ListSubscriptionsRequestMarshaller()));
    }

    @Override
    public ListSubscriptionsPaginator listSubscriptionsIterable(ListSubscriptionsRequest listSubscriptionsRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, SdkBaseException, SdkClientException, SNSException {
        return new ListSubscriptionsPaginator(this, listSubscriptionsRequest);
    }

    @Override
    public ListSubscriptionsByTopicResponse listSubscriptionsByTopic(ListSubscriptionsByTopicRequest listSubscriptionsByTopicRequest) throws InvalidParameterException, InternalErrorException, NotFoundException, AuthorizationErrorException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListSubscriptionsByTopicResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListSubscriptionsByTopicResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listSubscriptionsByTopicRequest).withMarshaller((Marshaller)new ListSubscriptionsByTopicRequestMarshaller()));
    }

    @Override
    public ListSubscriptionsByTopicPaginator listSubscriptionsByTopicIterable(ListSubscriptionsByTopicRequest listSubscriptionsByTopicRequest) throws InvalidParameterException, InternalErrorException, NotFoundException, AuthorizationErrorException, SdkBaseException, SdkClientException, SNSException {
        return new ListSubscriptionsByTopicPaginator(this, listSubscriptionsByTopicRequest);
    }

    @Override
    public ListTopicsResponse listTopics(ListTopicsRequest listTopicsRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListTopicsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListTopicsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listTopicsRequest).withMarshaller((Marshaller)new ListTopicsRequestMarshaller()));
    }

    @Override
    public ListTopicsPaginator listTopicsIterable(ListTopicsRequest listTopicsRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, SdkBaseException, SdkClientException, SNSException {
        return new ListTopicsPaginator(this, listTopicsRequest);
    }

    @Override
    public OptInPhoneNumberResponse optInPhoneNumber(OptInPhoneNumberRequest optInPhoneNumberRequest) throws ThrottledException, InternalErrorException, AuthorizationErrorException, InvalidParameterException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new OptInPhoneNumberResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (OptInPhoneNumberResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)optInPhoneNumberRequest).withMarshaller((Marshaller)new OptInPhoneNumberRequestMarshaller()));
    }

    @Override
    public PublishResponse publish(PublishRequest publishRequest) throws InvalidParameterException, InvalidParameterValueException, InternalErrorException, NotFoundException, EndpointDisabledException, PlatformApplicationDisabledException, AuthorizationErrorException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new PublishResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (PublishResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)publishRequest).withMarshaller((Marshaller)new PublishRequestMarshaller()));
    }

    @Override
    public RemovePermissionResponse removePermission(RemovePermissionRequest removePermissionRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new RemovePermissionResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (RemovePermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)removePermissionRequest).withMarshaller((Marshaller)new RemovePermissionRequestMarshaller()));
    }

    @Override
    public SetEndpointAttributesResponse setEndpointAttributes(SetEndpointAttributesRequest setEndpointAttributesRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SetEndpointAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (SetEndpointAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)setEndpointAttributesRequest).withMarshaller((Marshaller)new SetEndpointAttributesRequestMarshaller()));
    }

    @Override
    public SetPlatformApplicationAttributesResponse setPlatformApplicationAttributes(SetPlatformApplicationAttributesRequest setPlatformApplicationAttributesRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SetPlatformApplicationAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (SetPlatformApplicationAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)setPlatformApplicationAttributesRequest).withMarshaller((Marshaller)new SetPlatformApplicationAttributesRequestMarshaller()));
    }

    @Override
    public SetSMSAttributesResponse setSMSAttributes(SetSMSAttributesRequest setSMSAttributesRequest) throws InvalidParameterException, ThrottledException, InternalErrorException, AuthorizationErrorException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SetSMSAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (SetSMSAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)setSMSAttributesRequest).withMarshaller((Marshaller)new SetSMSAttributesRequestMarshaller()));
    }

    @Override
    public SetSubscriptionAttributesResponse setSubscriptionAttributes(SetSubscriptionAttributesRequest setSubscriptionAttributesRequest) throws InvalidParameterException, InternalErrorException, NotFoundException, AuthorizationErrorException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SetSubscriptionAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (SetSubscriptionAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)setSubscriptionAttributesRequest).withMarshaller((Marshaller)new SetSubscriptionAttributesRequestMarshaller()));
    }

    @Override
    public SetTopicAttributesResponse setTopicAttributes(SetTopicAttributesRequest setTopicAttributesRequest) throws InvalidParameterException, InternalErrorException, NotFoundException, AuthorizationErrorException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SetTopicAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (SetTopicAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)setTopicAttributesRequest).withMarshaller((Marshaller)new SetTopicAttributesRequestMarshaller()));
    }

    @Override
    public SubscribeResponse subscribe(SubscribeRequest subscribeRequest) throws SubscriptionLimitExceededException, InvalidParameterException, InternalErrorException, NotFoundException, AuthorizationErrorException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SubscribeResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (SubscribeResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)subscribeRequest).withMarshaller((Marshaller)new SubscribeRequestMarshaller()));
    }

    @Override
    public UnsubscribeResponse unsubscribe(UnsubscribeRequest unsubscribeRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, SdkBaseException, SdkClientException, SNSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new UnsubscribeResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (UnsubscribeResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)unsubscribeRequest).withMarshaller((Marshaller)new UnsubscribeRequestMarshaller()));
    }

    private List<Unmarshaller<AmazonServiceException, Node>> init() {
        ArrayList<Unmarshaller<AmazonServiceException, Node>> unmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new SubscriptionLimitExceededExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidParameterExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidParameterValueExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new EndpointDisabledExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new NotFoundExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new TopicLimitExceededExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new ThrottledExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new PlatformApplicationDisabledExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InternalErrorExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new AuthorizationErrorExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new StandardErrorUnmarshaller(SNSException.class));
        return unmarshallers;
    }

    public void close() {
        this.clientHandler.close();
    }
}

