/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sns.model.SetSubscriptionAttributesRequest;

public class SetSubscriptionAttributesRequestMarshaller
implements Marshaller<Request<SetSubscriptionAttributesRequest>, SetSubscriptionAttributesRequest> {
    public Request<SetSubscriptionAttributesRequest> marshall(SetSubscriptionAttributesRequest setSubscriptionAttributesRequest) {
        if (setSubscriptionAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setSubscriptionAttributesRequest, "SNSClient");
        request.addParameter("Action", "SetSubscriptionAttributes");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (setSubscriptionAttributesRequest.subscriptionArn() != null) {
            request.addParameter("SubscriptionArn", StringUtils.fromString((String)setSubscriptionAttributesRequest.subscriptionArn()));
        }
        if (setSubscriptionAttributesRequest.attributeName() != null) {
            request.addParameter("AttributeName", StringUtils.fromString((String)setSubscriptionAttributesRequest.attributeName()));
        }
        if (setSubscriptionAttributesRequest.attributeValue() != null) {
            request.addParameter("AttributeValue", StringUtils.fromString((String)setSubscriptionAttributesRequest.attributeValue()));
        }
        return request;
    }
}

