/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sns.model.ConfirmSubscriptionRequest;

public class ConfirmSubscriptionRequestMarshaller
implements Marshaller<Request<ConfirmSubscriptionRequest>, ConfirmSubscriptionRequest> {
    public Request<ConfirmSubscriptionRequest> marshall(ConfirmSubscriptionRequest confirmSubscriptionRequest) {
        if (confirmSubscriptionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)confirmSubscriptionRequest, "SNSClient");
        request.addParameter("Action", "ConfirmSubscription");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (confirmSubscriptionRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString((String)confirmSubscriptionRequest.topicArn()));
        }
        if (confirmSubscriptionRequest.token() != null) {
            request.addParameter("Token", StringUtils.fromString((String)confirmSubscriptionRequest.token()));
        }
        if (confirmSubscriptionRequest.authenticateOnUnsubscribe() != null) {
            request.addParameter("AuthenticateOnUnsubscribe", StringUtils.fromString((String)confirmSubscriptionRequest.authenticateOnUnsubscribe()));
        }
        return request;
    }
}

