/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sns.model.GetSmsAttributesRequest;

public class GetSmsAttributesRequestMarshaller
implements Marshaller<Request<GetSmsAttributesRequest>, GetSmsAttributesRequest> {
    public Request<GetSmsAttributesRequest> marshall(GetSmsAttributesRequest getSmsAttributesRequest) {
        if (getSmsAttributesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getSmsAttributesRequest, "SnsClient");
        request.addParameter("Action", "GetSMSAttributes");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (getSmsAttributesRequest.attributes().isEmpty() && !(getSmsAttributesRequest.attributes() instanceof SdkAutoConstructList)) {
            request.addParameter("attributes", "");
        } else if (!getSmsAttributesRequest.attributes().isEmpty() && !(getSmsAttributesRequest.attributes() instanceof SdkAutoConstructList)) {
            List<String> attributesList = getSmsAttributesRequest.attributes();
            int attributesListIndex = 1;
            for (String attributesListValue : attributesList) {
                if (attributesListValue != null) {
                    request.addParameter("attributes.member." + attributesListIndex, StringConversion.fromString((String)attributesListValue));
                }
                ++attributesListIndex;
            }
        }
        return request;
    }
}

