/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sns.model.CreateTopicRequest;

public class CreateTopicRequestMarshaller
implements Marshaller<Request<CreateTopicRequest>, CreateTopicRequest> {
    public Request<CreateTopicRequest> marshall(CreateTopicRequest createTopicRequest) {
        if (createTopicRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createTopicRequest, "SnsClient");
        request.addParameter("Action", "CreateTopic");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createTopicRequest.name() != null) {
            request.addParameter("Name", StringConversion.fromString((String)createTopicRequest.name()));
        }
        return request;
    }
}

