/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import java.util.Map;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sns.model.CreatePlatformEndpointRequest;

public class CreatePlatformEndpointRequestMarshaller
implements Marshaller<Request<CreatePlatformEndpointRequest>, CreatePlatformEndpointRequest> {
    public Request<CreatePlatformEndpointRequest> marshall(CreatePlatformEndpointRequest createPlatformEndpointRequest) {
        Map<String, String> attributes;
        if (createPlatformEndpointRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createPlatformEndpointRequest, "SnsClient");
        request.addParameter("Action", "CreatePlatformEndpoint");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createPlatformEndpointRequest.platformApplicationArn() != null) {
            request.addParameter("PlatformApplicationArn", StringConversion.fromString((String)createPlatformEndpointRequest.platformApplicationArn()));
        }
        if (createPlatformEndpointRequest.token() != null) {
            request.addParameter("Token", StringConversion.fromString((String)createPlatformEndpointRequest.token()));
        }
        if (createPlatformEndpointRequest.customUserData() != null) {
            request.addParameter("CustomUserData", StringConversion.fromString((String)createPlatformEndpointRequest.customUserData()));
        }
        if ((attributes = createPlatformEndpointRequest.attributes()) != null) {
            int attributesListIndex = 1;
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                if (entry.getKey() != null) {
                    request.addParameter("Attributes.entry." + attributesListIndex + ".key", StringConversion.fromString((String)entry.getKey()));
                }
                if (entry.getValue() != null) {
                    request.addParameter("Attributes.entry." + attributesListIndex + ".value", StringConversion.fromString((String)entry.getValue()));
                }
                ++attributesListIndex;
            }
        }
        return request;
    }
}

