/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.sns.model.SnsRequest;
import software.amazon.awssdk.services.sns.model.SubscriptionAttributesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubscribeRequest
extends SnsRequest
implements ToCopyableBuilder<Builder, SubscribeRequest> {
    private final String topicArn;
    private final String protocol;
    private final String endpoint;
    private final Map<String, String> attributes;
    private final Boolean returnSubscriptionArn;

    private SubscribeRequest(BuilderImpl builder) {
        super(builder);
        this.topicArn = builder.topicArn;
        this.protocol = builder.protocol;
        this.endpoint = builder.endpoint;
        this.attributes = builder.attributes;
        this.returnSubscriptionArn = builder.returnSubscriptionArn;
    }

    public String topicArn() {
        return this.topicArn;
    }

    public String protocol() {
        return this.protocol;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public Boolean returnSubscriptionArn() {
        return this.returnSubscriptionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnSubscriptionArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribeRequest)) {
            return false;
        }
        SubscribeRequest other = (SubscribeRequest)((Object)obj);
        return Objects.equals(this.topicArn(), other.topicArn()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.returnSubscriptionArn(), other.returnSubscriptionArn());
    }

    public String toString() {
        return ToString.builder((String)"SubscribeRequest").add("TopicArn", (Object)this.topicArn()).add("Protocol", (Object)this.protocol()).add("Endpoint", (Object)this.endpoint()).add("Attributes", this.attributes()).add("ReturnSubscriptionArn", (Object)this.returnSubscriptionArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "ReturnSubscriptionArn": {
                return Optional.ofNullable(clazz.cast(this.returnSubscriptionArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SnsRequest.BuilderImpl
    implements Builder {
        private String topicArn;
        private String protocol;
        private String endpoint;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private Boolean returnSubscriptionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribeRequest model) {
            super(model);
            this.topicArn(model.topicArn);
            this.protocol(model.protocol);
            this.endpoint(model.endpoint);
            this.attributes(model.attributes);
            this.returnSubscriptionArn(model.returnSubscriptionArn);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = SubscriptionAttributesMapCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = SubscriptionAttributesMapCopier.copy(attributes);
        }

        public final Boolean getReturnSubscriptionArn() {
            return this.returnSubscriptionArn;
        }

        @Override
        public final Builder returnSubscriptionArn(Boolean returnSubscriptionArn) {
            this.returnSubscriptionArn = returnSubscriptionArn;
            return this;
        }

        public final void setReturnSubscriptionArn(Boolean returnSubscriptionArn) {
            this.returnSubscriptionArn = returnSubscriptionArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubscribeRequest build() {
            return new SubscribeRequest(this);
        }
    }

    public static interface Builder
    extends SnsRequest.Builder,
    CopyableBuilder<Builder, SubscribeRequest> {
        public Builder topicArn(String var1);

        public Builder protocol(String var1);

        public Builder endpoint(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder returnSubscriptionArn(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

