/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.sns.model.MessageAttributeMapCopier;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;
import software.amazon.awssdk.services.sns.model.SnsRequest;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublishRequest
extends SnsRequest
implements ToCopyableBuilder<Builder, PublishRequest> {
    private final String topicArn;
    private final String targetArn;
    private final String phoneNumber;
    private final String message;
    private final String subject;
    private final String messageStructure;
    private final Map<String, MessageAttributeValue> messageAttributes;

    private PublishRequest(BuilderImpl builder) {
        super(builder);
        this.topicArn = builder.topicArn;
        this.targetArn = builder.targetArn;
        this.phoneNumber = builder.phoneNumber;
        this.message = builder.message;
        this.subject = builder.subject;
        this.messageStructure = builder.messageStructure;
        this.messageAttributes = builder.messageAttributes;
    }

    public String topicArn() {
        return this.topicArn;
    }

    public String targetArn() {
        return this.targetArn;
    }

    public String phoneNumber() {
        return this.phoneNumber;
    }

    public String message() {
        return this.message;
    }

    public String subject() {
        return this.subject;
    }

    public String messageStructure() {
        return this.messageStructure;
    }

    public Map<String, MessageAttributeValue> messageAttributes() {
        return this.messageAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageStructure());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishRequest)) {
            return false;
        }
        PublishRequest other = (PublishRequest)((Object)obj);
        return Objects.equals(this.topicArn(), other.topicArn()) && Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.phoneNumber(), other.phoneNumber()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.messageStructure(), other.messageStructure()) && Objects.equals(this.messageAttributes(), other.messageAttributes());
    }

    public String toString() {
        return ToString.builder((String)"PublishRequest").add("TopicArn", (Object)this.topicArn()).add("TargetArn", (Object)this.targetArn()).add("PhoneNumber", (Object)this.phoneNumber()).add("Message", (Object)this.message()).add("Subject", (Object)this.subject()).add("MessageStructure", (Object)this.messageStructure()).add("MessageAttributes", this.messageAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
            case "TargetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "MessageStructure": {
                return Optional.ofNullable(clazz.cast(this.messageStructure()));
            }
            case "MessageAttributes": {
                return Optional.ofNullable(clazz.cast(this.messageAttributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SnsRequest.BuilderImpl
    implements Builder {
        private String topicArn;
        private String targetArn;
        private String phoneNumber;
        private String message;
        private String subject;
        private String messageStructure;
        private Map<String, MessageAttributeValue> messageAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PublishRequest model) {
            super(model);
            this.topicArn(model.topicArn);
            this.targetArn(model.targetArn);
            this.phoneNumber(model.phoneNumber);
            this.message(model.message);
            this.subject(model.subject);
            this.messageStructure(model.messageStructure);
            this.messageAttributes(model.messageAttributes);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getSubject() {
            return this.subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final String getMessageStructure() {
            return this.messageStructure;
        }

        @Override
        public final Builder messageStructure(String messageStructure) {
            this.messageStructure = messageStructure;
            return this;
        }

        public final void setMessageStructure(String messageStructure) {
            this.messageStructure = messageStructure;
        }

        public final Map<String, MessageAttributeValue.Builder> getMessageAttributes() {
            return this.messageAttributes != null ? CollectionUtils.mapValues(this.messageAttributes, MessageAttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = MessageAttributeMapCopier.copy(messageAttributes);
            return this;
        }

        public final void setMessageAttributes(Map<String, MessageAttributeValue.BuilderImpl> messageAttributes) {
            this.messageAttributes = MessageAttributeMapCopier.copyFromBuilder(messageAttributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PublishRequest build() {
            return new PublishRequest(this);
        }
    }

    public static interface Builder
    extends SnsRequest.Builder,
    CopyableBuilder<Builder, PublishRequest> {
        public Builder topicArn(String var1);

        public Builder targetArn(String var1);

        public Builder phoneNumber(String var1);

        public Builder message(String var1);

        public Builder subject(String var1);

        public Builder messageStructure(String var1);

        public Builder messageAttributes(Map<String, MessageAttributeValue> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

