/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sns.model.ListOfPlatformApplicationsCopier;
import software.amazon.awssdk.services.sns.model.PlatformApplication;
import software.amazon.awssdk.services.sns.model.SnsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPlatformApplicationsResponse
extends SnsResponse
implements ToCopyableBuilder<Builder, ListPlatformApplicationsResponse> {
    private final List<PlatformApplication> platformApplications;
    private final String nextToken;

    private ListPlatformApplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.platformApplications = builder.platformApplications;
        this.nextToken = builder.nextToken;
    }

    public List<PlatformApplication> platformApplications() {
        return this.platformApplications;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.platformApplications());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlatformApplicationsResponse)) {
            return false;
        }
        ListPlatformApplicationsResponse other = (ListPlatformApplicationsResponse)((Object)obj);
        return Objects.equals(this.platformApplications(), other.platformApplications()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListPlatformApplicationsResponse").add("PlatformApplications", this.platformApplications()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlatformApplications": {
                return Optional.ofNullable(clazz.cast(this.platformApplications()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SnsResponse.BuilderImpl
    implements Builder {
        private List<PlatformApplication> platformApplications = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlatformApplicationsResponse model) {
            super(model);
            this.platformApplications(model.platformApplications);
            this.nextToken(model.nextToken);
        }

        public final Collection<PlatformApplication.Builder> getPlatformApplications() {
            return this.platformApplications != null ? (Collection)this.platformApplications.stream().map(PlatformApplication::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder platformApplications(Collection<PlatformApplication> platformApplications) {
            this.platformApplications = ListOfPlatformApplicationsCopier.copy(platformApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformApplications(PlatformApplication ... platformApplications) {
            this.platformApplications(Arrays.asList(platformApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformApplications(Consumer<PlatformApplication.Builder> ... platformApplications) {
            this.platformApplications(Stream.of(platformApplications).map(c -> (PlatformApplication)((PlatformApplication.Builder)PlatformApplication.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlatformApplications(Collection<PlatformApplication.BuilderImpl> platformApplications) {
            this.platformApplications = ListOfPlatformApplicationsCopier.copyFromBuilder(platformApplications);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPlatformApplicationsResponse build() {
            return new ListPlatformApplicationsResponse(this);
        }
    }

    public static interface Builder
    extends SnsResponse.Builder,
    CopyableBuilder<Builder, ListPlatformApplicationsResponse> {
        public Builder platformApplications(Collection<PlatformApplication> var1);

        public Builder platformApplications(PlatformApplication ... var1);

        public Builder platformApplications(Consumer<PlatformApplication.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

