/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest;

public class ListSubscriptionsRequestMarshaller
implements Marshaller<Request<ListSubscriptionsRequest>, ListSubscriptionsRequest> {
    public Request<ListSubscriptionsRequest> marshall(ListSubscriptionsRequest listSubscriptionsRequest) {
        if (listSubscriptionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listSubscriptionsRequest, "SnsClient");
        request.addParameter("Action", "ListSubscriptions");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (listSubscriptionsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)listSubscriptionsRequest.nextToken()));
        }
        return request;
    }
}

