/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sns.model.GetTopicAttributesRequest;

public class GetTopicAttributesRequestMarshaller
implements Marshaller<Request<GetTopicAttributesRequest>, GetTopicAttributesRequest> {
    public Request<GetTopicAttributesRequest> marshall(GetTopicAttributesRequest getTopicAttributesRequest) {
        if (getTopicAttributesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getTopicAttributesRequest, "SnsClient");
        request.addParameter("Action", "GetTopicAttributes");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (getTopicAttributesRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringConversion.fromString((String)getTopicAttributesRequest.topicArn()));
        }
        return request;
    }
}

