/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sns.model.DeleteEndpointRequest;

public class DeleteEndpointRequestMarshaller
implements Marshaller<Request<DeleteEndpointRequest>, DeleteEndpointRequest> {
    public Request<DeleteEndpointRequest> marshall(DeleteEndpointRequest deleteEndpointRequest) {
        if (deleteEndpointRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteEndpointRequest, "SnsClient");
        request.addParameter("Action", "DeleteEndpoint");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteEndpointRequest.endpointArn() != null) {
            request.addParameter("EndpointArn", StringConversion.fromString((String)deleteEndpointRequest.endpointArn()));
        }
        return request;
    }
}

