/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sns.model.AddPermissionRequest;

public class AddPermissionRequestMarshaller
implements Marshaller<Request<AddPermissionRequest>, AddPermissionRequest> {
    public Request<AddPermissionRequest> marshall(AddPermissionRequest addPermissionRequest) {
        if (addPermissionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)addPermissionRequest, "SnsClient");
        request.addParameter("Action", "AddPermission");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (addPermissionRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringConversion.fromString((String)addPermissionRequest.topicArn()));
        }
        if (addPermissionRequest.label() != null) {
            request.addParameter("Label", StringConversion.fromString((String)addPermissionRequest.label()));
        }
        if (addPermissionRequest.awsAccountIds().isEmpty() && !(addPermissionRequest.awsAccountIds() instanceof SdkAutoConstructList)) {
            request.addParameter("AWSAccountId", "");
        } else if (!addPermissionRequest.awsAccountIds().isEmpty() && !(addPermissionRequest.awsAccountIds() instanceof SdkAutoConstructList)) {
            List<String> aWSAccountIdsList = addPermissionRequest.awsAccountIds();
            int aWSAccountIdsListIndex = 1;
            for (String aWSAccountIdsListValue : aWSAccountIdsList) {
                if (aWSAccountIdsListValue != null) {
                    request.addParameter("AWSAccountId.member." + aWSAccountIdsListIndex, StringConversion.fromString((String)aWSAccountIdsListValue));
                }
                ++aWSAccountIdsListIndex;
            }
        }
        if (addPermissionRequest.actionNames().isEmpty() && !(addPermissionRequest.actionNames() instanceof SdkAutoConstructList)) {
            request.addParameter("ActionName", "");
        } else if (!addPermissionRequest.actionNames().isEmpty() && !(addPermissionRequest.actionNames() instanceof SdkAutoConstructList)) {
            List<String> actionNamesList = addPermissionRequest.actionNames();
            int actionNamesListIndex = 1;
            for (String actionNamesListValue : actionNamesList) {
                if (actionNamesListValue != null) {
                    request.addParameter("ActionName.member." + actionNamesListIndex, StringConversion.fromString((String)actionNamesListValue));
                }
                ++actionNamesListIndex;
            }
        }
        return request;
    }
}

