/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sns.model.ListStringCopier;
import software.amazon.awssdk.services.sns.model.SnsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSmsAttributesRequest
extends SnsRequest
implements ToCopyableBuilder<Builder, GetSmsAttributesRequest> {
    private final List<String> attributes;

    private GetSmsAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
    }

    public List<String> attributes() {
        return this.attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSmsAttributesRequest)) {
            return false;
        }
        GetSmsAttributesRequest other = (GetSmsAttributesRequest)((Object)obj);
        return Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        return ToString.builder((String)"GetSmsAttributesRequest").add("Attributes", this.attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SnsRequest.BuilderImpl
    implements Builder {
        private List<String> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSmsAttributesRequest model) {
            super(model);
            this.attributes(model.attributes);
        }

        public final Collection<String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Collection<String> attributes) {
            this.attributes = ListStringCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(String ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<String> attributes) {
            this.attributes = ListStringCopier.copy(attributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSmsAttributesRequest build() {
            return new GetSmsAttributesRequest(this);
        }
    }

    public static interface Builder
    extends SnsRequest.Builder,
    CopyableBuilder<Builder, GetSmsAttributesRequest> {
        public Builder attributes(Collection<String> var1);

        public Builder attributes(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

