/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonClientException;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.auth.policy.Action;
import software.amazon.awssdk.auth.policy.Condition;
import software.amazon.awssdk.auth.policy.Policy;
import software.amazon.awssdk.auth.policy.Principal;
import software.amazon.awssdk.auth.policy.Resource;
import software.amazon.awssdk.auth.policy.Statement;
import software.amazon.awssdk.auth.policy.actions.SQSActions;
import software.amazon.awssdk.auth.policy.conditions.ConditionFactory;
import software.amazon.awssdk.services.sns.SNSClient;
import software.amazon.awssdk.services.sns.model.SubscribeRequest;
import software.amazon.awssdk.services.sns.model.SubscribeResponse;
import software.amazon.awssdk.services.sqs.SQSClient;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.services.sqs.model.SetQueueAttributesRequest;

public class Topics {
    public static String subscribeQueue(SNSClient sns, SQSClient sqs, String snsTopicArn, String sqsQueueUrl) throws AmazonClientException, AmazonServiceException {
        return Topics.subscribeQueue(sns, sqs, snsTopicArn, sqsQueueUrl, false);
    }

    public static String subscribeQueue(SNSClient sns, SQSClient sqs, String snsTopicArn, String sqsQueueUrl, boolean extendPolicy) throws AmazonClientException, AmazonServiceException {
        List<String> sqsAttrNames = Arrays.asList(QueueAttributeName.QueueArn.toString(), QueueAttributeName.Policy.toString());
        Map sqsAttrs = sqs.getQueueAttributes((GetQueueAttributesRequest)GetQueueAttributesRequest.builder().queueUrl(sqsQueueUrl).attributeNames(sqsAttrNames).build()).attributes();
        String sqsQueueArn = (String)sqsAttrs.get(QueueAttributeName.QueueArn.toString());
        String policyJson = (String)sqsAttrs.get(QueueAttributeName.Policy.toString());
        Policy policy = extendPolicy && policyJson != null && policyJson.length() > 0 ? Policy.fromJson((String)policyJson) : new Policy();
        policy.getStatements().add(new Statement(Statement.Effect.Allow).withId("topic-subscription-" + snsTopicArn).withPrincipals(new Principal[]{Principal.ALL_USERS}).withActions(new Action[]{SQSActions.SendMessage}).withResources(new Resource[]{new Resource(sqsQueueArn)}).withConditions(new Condition[]{ConditionFactory.newSourceArnCondition((String)snsTopicArn)}));
        HashMap<String, String> newAttrs = new HashMap<String, String>();
        newAttrs.put(QueueAttributeName.Policy.toString(), policy.toJson());
        sqs.setQueueAttributes((SetQueueAttributesRequest)SetQueueAttributesRequest.builder().queueUrl(sqsQueueUrl).attributes(newAttrs).build());
        SubscribeResponse subscribeResult = sns.subscribe((SubscribeRequest)((Object)SubscribeRequest.builder().topicArn(snsTopicArn).protocol("sqs").endpoint(sqsQueueArn).build()));
        return subscribeResult.subscriptionArn();
    }
}

