/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sns.model.SetTopicAttributesRequest;
import software.amazon.awssdk.util.StringUtils;

public class SetTopicAttributesRequestMarshaller
implements Marshaller<Request<SetTopicAttributesRequest>, SetTopicAttributesRequest> {
    public Request<SetTopicAttributesRequest> marshall(SetTopicAttributesRequest setTopicAttributesRequest) {
        if (setTopicAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setTopicAttributesRequest, "SNSClient");
        request.addParameter("Action", "SetTopicAttributes");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (setTopicAttributesRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString((String)setTopicAttributesRequest.topicArn()));
        }
        if (setTopicAttributesRequest.attributeName() != null) {
            request.addParameter("AttributeName", StringUtils.fromString((String)setTopicAttributesRequest.attributeName()));
        }
        if (setTopicAttributesRequest.attributeValue() != null) {
            request.addParameter("AttributeValue", StringUtils.fromString((String)setTopicAttributesRequest.attributeValue()));
        }
        return request;
    }
}

