/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sns.model.RemovePermissionRequest;
import software.amazon.awssdk.util.StringUtils;

public class RemovePermissionRequestMarshaller
implements Marshaller<Request<RemovePermissionRequest>, RemovePermissionRequest> {
    public Request<RemovePermissionRequest> marshall(RemovePermissionRequest removePermissionRequest) {
        if (removePermissionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)removePermissionRequest, "SNSClient");
        request.addParameter("Action", "RemovePermission");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (removePermissionRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString((String)removePermissionRequest.topicArn()));
        }
        if (removePermissionRequest.label() != null) {
            request.addParameter("Label", StringUtils.fromString((String)removePermissionRequest.label()));
        }
        return request;
    }
}

