/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for Unsubscribe action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UnsubscribeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UnsubscribeRequest.Builder, UnsubscribeRequest> {
    private final String subscriptionArn;

    private UnsubscribeRequest(BuilderImpl builder) {
        this.subscriptionArn = builder.subscriptionArn;
    }

    /**
     * <p>
     * The ARN of the subscription to be deleted.
     * </p>
     * 
     * @return The ARN of the subscription to be deleted.
     */
    public String subscriptionArn() {
        return subscriptionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((subscriptionArn() == null) ? 0 : subscriptionArn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnsubscribeRequest)) {
            return false;
        }
        UnsubscribeRequest other = (UnsubscribeRequest) obj;
        if (other.subscriptionArn() == null ^ this.subscriptionArn() == null) {
            return false;
        }
        if (other.subscriptionArn() != null && !other.subscriptionArn().equals(this.subscriptionArn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (subscriptionArn() != null) {
            sb.append("SubscriptionArn: ").append(subscriptionArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UnsubscribeRequest> {
        /**
         * <p>
         * The ARN of the subscription to be deleted.
         * </p>
         * 
         * @param subscriptionArn
         *        The ARN of the subscription to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionArn(String subscriptionArn);
    }

    private static final class BuilderImpl implements Builder {
        private String subscriptionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UnsubscribeRequest model) {
            setSubscriptionArn(model.subscriptionArn);
        }

        public final String getSubscriptionArn() {
            return subscriptionArn;
        }

        @Override
        public final Builder subscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
            return this;
        }

        public final void setSubscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
        }

        @Override
        public UnsubscribeRequest build() {
            return new UnsubscribeRequest(this);
        }
    }
}
