/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A wrapper type for the attributes of an Amazon SNS subscription.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Subscription implements ToCopyableBuilder<Subscription.Builder, Subscription> {
    private final String subscriptionArn;

    private final String owner;

    private final String protocol;

    private final String endpoint;

    private final String topicArn;

    private Subscription(BuilderImpl builder) {
        this.subscriptionArn = builder.subscriptionArn;
        this.owner = builder.owner;
        this.protocol = builder.protocol;
        this.endpoint = builder.endpoint;
        this.topicArn = builder.topicArn;
    }

    /**
     * <p>
     * The subscription's ARN.
     * </p>
     * 
     * @return The subscription's ARN.
     */
    public String subscriptionArn() {
        return subscriptionArn;
    }

    /**
     * <p>
     * The subscription's owner.
     * </p>
     * 
     * @return The subscription's owner.
     */
    public String owner() {
        return owner;
    }

    /**
     * <p>
     * The subscription's protocol.
     * </p>
     * 
     * @return The subscription's protocol.
     */
    public String protocol() {
        return protocol;
    }

    /**
     * <p>
     * The subscription's endpoint (format depends on the protocol).
     * </p>
     * 
     * @return The subscription's endpoint (format depends on the protocol).
     */
    public String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The ARN of the subscription's topic.
     * </p>
     * 
     * @return The ARN of the subscription's topic.
     */
    public String topicArn() {
        return topicArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((subscriptionArn() == null) ? 0 : subscriptionArn().hashCode());
        hashCode = 31 * hashCode + ((owner() == null) ? 0 : owner().hashCode());
        hashCode = 31 * hashCode + ((protocol() == null) ? 0 : protocol().hashCode());
        hashCode = 31 * hashCode + ((endpoint() == null) ? 0 : endpoint().hashCode());
        hashCode = 31 * hashCode + ((topicArn() == null) ? 0 : topicArn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription) obj;
        if (other.subscriptionArn() == null ^ this.subscriptionArn() == null) {
            return false;
        }
        if (other.subscriptionArn() != null && !other.subscriptionArn().equals(this.subscriptionArn())) {
            return false;
        }
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        if (other.owner() != null && !other.owner().equals(this.owner())) {
            return false;
        }
        if (other.protocol() == null ^ this.protocol() == null) {
            return false;
        }
        if (other.protocol() != null && !other.protocol().equals(this.protocol())) {
            return false;
        }
        if (other.endpoint() == null ^ this.endpoint() == null) {
            return false;
        }
        if (other.endpoint() != null && !other.endpoint().equals(this.endpoint())) {
            return false;
        }
        if (other.topicArn() == null ^ this.topicArn() == null) {
            return false;
        }
        if (other.topicArn() != null && !other.topicArn().equals(this.topicArn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (subscriptionArn() != null) {
            sb.append("SubscriptionArn: ").append(subscriptionArn()).append(",");
        }
        if (owner() != null) {
            sb.append("Owner: ").append(owner()).append(",");
        }
        if (protocol() != null) {
            sb.append("Protocol: ").append(protocol()).append(",");
        }
        if (endpoint() != null) {
            sb.append("Endpoint: ").append(endpoint()).append(",");
        }
        if (topicArn() != null) {
            sb.append("TopicArn: ").append(topicArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Subscription> {
        /**
         * <p>
         * The subscription's ARN.
         * </p>
         * 
         * @param subscriptionArn
         *        The subscription's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionArn(String subscriptionArn);

        /**
         * <p>
         * The subscription's owner.
         * </p>
         * 
         * @param owner
         *        The subscription's owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The subscription's protocol.
         * </p>
         * 
         * @param protocol
         *        The subscription's protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The subscription's endpoint (format depends on the protocol).
         * </p>
         * 
         * @param endpoint
         *        The subscription's endpoint (format depends on the protocol).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The ARN of the subscription's topic.
         * </p>
         * 
         * @param topicArn
         *        The ARN of the subscription's topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);
    }

    private static final class BuilderImpl implements Builder {
        private String subscriptionArn;

        private String owner;

        private String protocol;

        private String endpoint;

        private String topicArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Subscription model) {
            setSubscriptionArn(model.subscriptionArn);
            setOwner(model.owner);
            setProtocol(model.protocol);
            setEndpoint(model.endpoint);
            setTopicArn(model.topicArn);
        }

        public final String getSubscriptionArn() {
            return subscriptionArn;
        }

        @Override
        public final Builder subscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
            return this;
        }

        public final void setSubscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
        }

        public final String getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public Subscription build() {
            return new Subscription(this);
        }
    }
}
