/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for Subscribe action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SubscribeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<SubscribeRequest.Builder, SubscribeRequest> {
    private final String topicArn;

    private final String protocol;

    private final String endpoint;

    private SubscribeRequest(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.protocol = builder.protocol;
        this.endpoint = builder.endpoint;
    }

    /**
     * <p>
     * The ARN of the topic you want to subscribe to.
     * </p>
     * 
     * @return The ARN of the topic you want to subscribe to.
     */
    public String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * The protocol you want to use. Supported protocols include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>http</code> -- delivery of JSON-encoded message via HTTP POST
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>https</code> -- delivery of JSON-encoded message via HTTPS POST
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>email</code> -- delivery of message via SMTP
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>email-json</code> -- delivery of JSON-encoded message via SMTP
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sms</code> -- delivery of message via SMS
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqs</code> -- delivery of JSON-encoded message to an Amazon SQS queue
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>application</code> -- delivery of JSON-encoded message to an EndpointArn for a mobile app and device.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>lambda</code> -- delivery of JSON-encoded message to an AWS Lambda function.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The protocol you want to use. Supported protocols include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>http</code> -- delivery of JSON-encoded message via HTTP POST
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>https</code> -- delivery of JSON-encoded message via HTTPS POST
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>email</code> -- delivery of message via SMTP
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>email-json</code> -- delivery of JSON-encoded message via SMTP
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sms</code> -- delivery of message via SMS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqs</code> -- delivery of JSON-encoded message to an Amazon SQS queue
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>application</code> -- delivery of JSON-encoded message to an EndpointArn for a mobile app and
     *         device.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>lambda</code> -- delivery of JSON-encoded message to an AWS Lambda function.
     *         </p>
     *         </li>
     */
    public String protocol() {
        return protocol;
    }

    /**
     * <p>
     * The endpoint that you want to receive notifications. Endpoints vary by protocol:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For the <code>http</code> protocol, the endpoint is an URL beginning with "http://"
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>https</code> protocol, the endpoint is a URL beginning with "https://"
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>email</code> protocol, the endpoint is an email address
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>email-json</code> protocol, the endpoint is an email address
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>sms</code> protocol, the endpoint is a phone number of an SMS-enabled device
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>sqs</code> protocol, the endpoint is the ARN of an Amazon SQS queue
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>application</code> protocol, the endpoint is the EndpointArn of a mobile app and device.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>lambda</code> protocol, the endpoint is the ARN of an AWS Lambda function.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The endpoint that you want to receive notifications. Endpoints vary by protocol:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For the <code>http</code> protocol, the endpoint is an URL beginning with "http://"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>https</code> protocol, the endpoint is a URL beginning with "https://"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>email</code> protocol, the endpoint is an email address
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>email-json</code> protocol, the endpoint is an email address
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>sms</code> protocol, the endpoint is a phone number of an SMS-enabled device
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>sqs</code> protocol, the endpoint is the ARN of an Amazon SQS queue
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>application</code> protocol, the endpoint is the EndpointArn of a mobile app and device.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>lambda</code> protocol, the endpoint is the ARN of an AWS Lambda function.
     *         </p>
     *         </li>
     */
    public String endpoint() {
        return endpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((topicArn() == null) ? 0 : topicArn().hashCode());
        hashCode = 31 * hashCode + ((protocol() == null) ? 0 : protocol().hashCode());
        hashCode = 31 * hashCode + ((endpoint() == null) ? 0 : endpoint().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribeRequest)) {
            return false;
        }
        SubscribeRequest other = (SubscribeRequest) obj;
        if (other.topicArn() == null ^ this.topicArn() == null) {
            return false;
        }
        if (other.topicArn() != null && !other.topicArn().equals(this.topicArn())) {
            return false;
        }
        if (other.protocol() == null ^ this.protocol() == null) {
            return false;
        }
        if (other.protocol() != null && !other.protocol().equals(this.protocol())) {
            return false;
        }
        if (other.endpoint() == null ^ this.endpoint() == null) {
            return false;
        }
        if (other.endpoint() != null && !other.endpoint().equals(this.endpoint())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (topicArn() != null) {
            sb.append("TopicArn: ").append(topicArn()).append(",");
        }
        if (protocol() != null) {
            sb.append("Protocol: ").append(protocol()).append(",");
        }
        if (endpoint() != null) {
            sb.append("Endpoint: ").append(endpoint()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SubscribeRequest> {
        /**
         * <p>
         * The ARN of the topic you want to subscribe to.
         * </p>
         * 
         * @param topicArn
         *        The ARN of the topic you want to subscribe to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * The protocol you want to use. Supported protocols include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>http</code> -- delivery of JSON-encoded message via HTTP POST
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>https</code> -- delivery of JSON-encoded message via HTTPS POST
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>email</code> -- delivery of message via SMTP
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>email-json</code> -- delivery of JSON-encoded message via SMTP
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sms</code> -- delivery of message via SMS
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqs</code> -- delivery of JSON-encoded message to an Amazon SQS queue
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>application</code> -- delivery of JSON-encoded message to an EndpointArn for a mobile app and device.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>lambda</code> -- delivery of JSON-encoded message to an AWS Lambda function.
         * </p>
         * </li>
         * </ul>
         * 
         * @param protocol
         *        The protocol you want to use. Supported protocols include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>http</code> -- delivery of JSON-encoded message via HTTP POST
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>https</code> -- delivery of JSON-encoded message via HTTPS POST
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>email</code> -- delivery of message via SMTP
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>email-json</code> -- delivery of JSON-encoded message via SMTP
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sms</code> -- delivery of message via SMS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqs</code> -- delivery of JSON-encoded message to an Amazon SQS queue
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>application</code> -- delivery of JSON-encoded message to an EndpointArn for a mobile app and
         *        device.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>lambda</code> -- delivery of JSON-encoded message to an AWS Lambda function.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The endpoint that you want to receive notifications. Endpoints vary by protocol:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For the <code>http</code> protocol, the endpoint is an URL beginning with "http://"
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>https</code> protocol, the endpoint is a URL beginning with "https://"
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>email</code> protocol, the endpoint is an email address
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>email-json</code> protocol, the endpoint is an email address
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>sms</code> protocol, the endpoint is a phone number of an SMS-enabled device
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>sqs</code> protocol, the endpoint is the ARN of an Amazon SQS queue
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>application</code> protocol, the endpoint is the EndpointArn of a mobile app and device.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>lambda</code> protocol, the endpoint is the ARN of an AWS Lambda function.
         * </p>
         * </li>
         * </ul>
         * 
         * @param endpoint
         *        The endpoint that you want to receive notifications. Endpoints vary by protocol:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For the <code>http</code> protocol, the endpoint is an URL beginning with "http://"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>https</code> protocol, the endpoint is a URL beginning with "https://"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>email</code> protocol, the endpoint is an email address
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>email-json</code> protocol, the endpoint is an email address
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>sms</code> protocol, the endpoint is a phone number of an SMS-enabled device
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>sqs</code> protocol, the endpoint is the ARN of an Amazon SQS queue
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>application</code> protocol, the endpoint is the EndpointArn of a mobile app and device.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>lambda</code> protocol, the endpoint is the ARN of an AWS Lambda function.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);
    }

    private static final class BuilderImpl implements Builder {
        private String topicArn;

        private String protocol;

        private String endpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribeRequest model) {
            setTopicArn(model.topicArn);
            setProtocol(model.protocol);
            setEndpoint(model.endpoint);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public SubscribeRequest build() {
            return new SubscribeRequest(this);
        }
    }
}
