/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for SetPlatformApplicationAttributes action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SetPlatformApplicationAttributesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<SetPlatformApplicationAttributesRequest.Builder, SetPlatformApplicationAttributesRequest> {
    private final String platformApplicationArn;

    private final Map<String, String> attributes;

    private SetPlatformApplicationAttributesRequest(BuilderImpl builder) {
        this.platformApplicationArn = builder.platformApplicationArn;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * PlatformApplicationArn for SetPlatformApplicationAttributes action.
     * </p>
     * 
     * @return PlatformApplicationArn for SetPlatformApplicationAttributes action.
     */
    public String platformApplicationArn() {
        return platformApplicationArn;
    }

    /**
     * <p>
     * A map of the platform application attributes. Attributes in this map include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PlatformCredential</code> -- The credential received from the notification service. For APNS/APNS_SANDBOX,
     * PlatformCredential is private key. For GCM, PlatformCredential is "API key". For ADM, PlatformCredential is
     * "client secret".
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PlatformPrincipal</code> -- The principal received from the notification service. For APNS/APNS_SANDBOX,
     * PlatformPrincipal is SSL certificate. For GCM, PlatformPrincipal is not applicable. For ADM, PlatformPrincipal is
     * "client id".
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EventEndpointCreated</code> -- Topic ARN to which EndpointCreated event notifications should be sent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EventEndpointDeleted</code> -- Topic ARN to which EndpointDeleted event notifications should be sent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EventEndpointUpdated</code> -- Topic ARN to which EndpointUpdate event notifications should be sent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EventDeliveryFailure</code> -- Topic ARN to which DeliveryFailure event notifications should be sent upon
     * Direct Publish delivery failure (permanent) to one of the application's endpoints.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SuccessFeedbackRoleArn</code> -- IAM role ARN used to give Amazon SNS write access to use CloudWatch Logs
     * on your behalf.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FailureFeedbackRoleArn</code> -- IAM role ARN used to give Amazon SNS write access to use CloudWatch Logs
     * on your behalf.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SuccessFeedbackSampleRate</code> -- Sample rate percentage (0-100) of successfully delivered messages.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A map of the platform application attributes. Attributes in this map include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PlatformCredential</code> -- The credential received from the notification service. For
     *         APNS/APNS_SANDBOX, PlatformCredential is private key. For GCM, PlatformCredential is "API key". For ADM,
     *         PlatformCredential is "client secret".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PlatformPrincipal</code> -- The principal received from the notification service. For
     *         APNS/APNS_SANDBOX, PlatformPrincipal is SSL certificate. For GCM, PlatformPrincipal is not applicable.
     *         For ADM, PlatformPrincipal is "client id".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EventEndpointCreated</code> -- Topic ARN to which EndpointCreated event notifications should be
     *         sent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EventEndpointDeleted</code> -- Topic ARN to which EndpointDeleted event notifications should be
     *         sent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EventEndpointUpdated</code> -- Topic ARN to which EndpointUpdate event notifications should be
     *         sent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EventDeliveryFailure</code> -- Topic ARN to which DeliveryFailure event notifications should be
     *         sent upon Direct Publish delivery failure (permanent) to one of the application's endpoints.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SuccessFeedbackRoleArn</code> -- IAM role ARN used to give Amazon SNS write access to use
     *         CloudWatch Logs on your behalf.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FailureFeedbackRoleArn</code> -- IAM role ARN used to give Amazon SNS write access to use
     *         CloudWatch Logs on your behalf.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SuccessFeedbackSampleRate</code> -- Sample rate percentage (0-100) of successfully delivered
     *         messages.
     *         </p>
     *         </li>
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((platformApplicationArn() == null) ? 0 : platformApplicationArn().hashCode());
        hashCode = 31 * hashCode + ((attributes() == null) ? 0 : attributes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetPlatformApplicationAttributesRequest)) {
            return false;
        }
        SetPlatformApplicationAttributesRequest other = (SetPlatformApplicationAttributesRequest) obj;
        if (other.platformApplicationArn() == null ^ this.platformApplicationArn() == null) {
            return false;
        }
        if (other.platformApplicationArn() != null && !other.platformApplicationArn().equals(this.platformApplicationArn())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        if (other.attributes() != null && !other.attributes().equals(this.attributes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (platformApplicationArn() != null) {
            sb.append("PlatformApplicationArn: ").append(platformApplicationArn()).append(",");
        }
        if (attributes() != null) {
            sb.append("Attributes: ").append(attributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SetPlatformApplicationAttributesRequest> {
        /**
         * <p>
         * PlatformApplicationArn for SetPlatformApplicationAttributes action.
         * </p>
         * 
         * @param platformApplicationArn
         *        PlatformApplicationArn for SetPlatformApplicationAttributes action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformApplicationArn(String platformApplicationArn);

        /**
         * <p>
         * A map of the platform application attributes. Attributes in this map include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PlatformCredential</code> -- The credential received from the notification service. For
         * APNS/APNS_SANDBOX, PlatformCredential is private key. For GCM, PlatformCredential is "API key". For ADM,
         * PlatformCredential is "client secret".
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PlatformPrincipal</code> -- The principal received from the notification service. For
         * APNS/APNS_SANDBOX, PlatformPrincipal is SSL certificate. For GCM, PlatformPrincipal is not applicable. For
         * ADM, PlatformPrincipal is "client id".
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EventEndpointCreated</code> -- Topic ARN to which EndpointCreated event notifications should be sent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EventEndpointDeleted</code> -- Topic ARN to which EndpointDeleted event notifications should be sent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EventEndpointUpdated</code> -- Topic ARN to which EndpointUpdate event notifications should be sent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EventDeliveryFailure</code> -- Topic ARN to which DeliveryFailure event notifications should be sent
         * upon Direct Publish delivery failure (permanent) to one of the application's endpoints.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SuccessFeedbackRoleArn</code> -- IAM role ARN used to give Amazon SNS write access to use CloudWatch
         * Logs on your behalf.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FailureFeedbackRoleArn</code> -- IAM role ARN used to give Amazon SNS write access to use CloudWatch
         * Logs on your behalf.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SuccessFeedbackSampleRate</code> -- Sample rate percentage (0-100) of successfully delivered messages.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributes
         *        A map of the platform application attributes. Attributes in this map include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PlatformCredential</code> -- The credential received from the notification service. For
         *        APNS/APNS_SANDBOX, PlatformCredential is private key. For GCM, PlatformCredential is "API key". For
         *        ADM, PlatformCredential is "client secret".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PlatformPrincipal</code> -- The principal received from the notification service. For
         *        APNS/APNS_SANDBOX, PlatformPrincipal is SSL certificate. For GCM, PlatformPrincipal is not applicable.
         *        For ADM, PlatformPrincipal is "client id".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EventEndpointCreated</code> -- Topic ARN to which EndpointCreated event notifications should be
         *        sent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EventEndpointDeleted</code> -- Topic ARN to which EndpointDeleted event notifications should be
         *        sent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EventEndpointUpdated</code> -- Topic ARN to which EndpointUpdate event notifications should be
         *        sent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EventDeliveryFailure</code> -- Topic ARN to which DeliveryFailure event notifications should be
         *        sent upon Direct Publish delivery failure (permanent) to one of the application's endpoints.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SuccessFeedbackRoleArn</code> -- IAM role ARN used to give Amazon SNS write access to use
         *        CloudWatch Logs on your behalf.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FailureFeedbackRoleArn</code> -- IAM role ARN used to give Amazon SNS write access to use
         *        CloudWatch Logs on your behalf.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SuccessFeedbackSampleRate</code> -- Sample rate percentage (0-100) of successfully delivered
         *        messages.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);
    }

    private static final class BuilderImpl implements Builder {
        private String platformApplicationArn;

        private Map<String, String> attributes = new SdkInternalMap<>();

        private BuilderImpl() {
        }

        private BuilderImpl(SetPlatformApplicationAttributesRequest model) {
            setPlatformApplicationArn(model.platformApplicationArn);
            setAttributes(model.attributes);
        }

        public final String getPlatformApplicationArn() {
            return platformApplicationArn;
        }

        @Override
        public final Builder platformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
            return this;
        }

        public final void setPlatformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
        }

        @Override
        public SetPlatformApplicationAttributesRequest build() {
            return new SetPlatformApplicationAttributesRequest(this);
        }
    }
}
