/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for GetPlatformApplicationAttributes action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetPlatformApplicationAttributesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetPlatformApplicationAttributesRequest.Builder, GetPlatformApplicationAttributesRequest> {
    private final String platformApplicationArn;

    private GetPlatformApplicationAttributesRequest(BuilderImpl builder) {
        this.platformApplicationArn = builder.platformApplicationArn;
    }

    /**
     * <p>
     * PlatformApplicationArn for GetPlatformApplicationAttributesInput.
     * </p>
     * 
     * @return PlatformApplicationArn for GetPlatformApplicationAttributesInput.
     */
    public String platformApplicationArn() {
        return platformApplicationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((platformApplicationArn() == null) ? 0 : platformApplicationArn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPlatformApplicationAttributesRequest)) {
            return false;
        }
        GetPlatformApplicationAttributesRequest other = (GetPlatformApplicationAttributesRequest) obj;
        if (other.platformApplicationArn() == null ^ this.platformApplicationArn() == null) {
            return false;
        }
        if (other.platformApplicationArn() != null && !other.platformApplicationArn().equals(this.platformApplicationArn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (platformApplicationArn() != null) {
            sb.append("PlatformApplicationArn: ").append(platformApplicationArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetPlatformApplicationAttributesRequest> {
        /**
         * <p>
         * PlatformApplicationArn for GetPlatformApplicationAttributesInput.
         * </p>
         * 
         * @param platformApplicationArn
         *        PlatformApplicationArn for GetPlatformApplicationAttributesInput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformApplicationArn(String platformApplicationArn);
    }

    private static final class BuilderImpl implements Builder {
        private String platformApplicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPlatformApplicationAttributesRequest model) {
            setPlatformApplicationArn(model.platformApplicationArn);
        }

        public final String getPlatformApplicationArn() {
            return platformApplicationArn;
        }

        @Override
        public final Builder platformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
            return this;
        }

        public final void setPlatformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
        }

        @Override
        public GetPlatformApplicationAttributesRequest build() {
            return new GetPlatformApplicationAttributesRequest(this);
        }
    }
}
