/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response from CreateTopic action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateTopicResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateTopicResponse.Builder, CreateTopicResponse> {
    private final String topicArn;

    private CreateTopicResponse(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) assigned to the created topic.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) assigned to the created topic.
     */
    public String topicArn() {
        return topicArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((topicArn() == null) ? 0 : topicArn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTopicResponse)) {
            return false;
        }
        CreateTopicResponse other = (CreateTopicResponse) obj;
        if (other.topicArn() == null ^ this.topicArn() == null) {
            return false;
        }
        if (other.topicArn() != null && !other.topicArn().equals(this.topicArn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (topicArn() != null) {
            sb.append("TopicArn: ").append(topicArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateTopicResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) assigned to the created topic.
         * </p>
         * 
         * @param topicArn
         *        The Amazon Resource Name (ARN) assigned to the created topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);
    }

    private static final class BuilderImpl implements Builder {
        private String topicArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTopicResponse model) {
            setTopicArn(model.topicArn);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public CreateTopicResponse build() {
            return new CreateTopicResponse(this);
        }
    }
}
