/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum JobState {
    NEW("New"),
    PREPARING_APPLIANCE("PreparingAppliance"),
    PREPARING_SHIPMENT("PreparingShipment"),
    IN_TRANSIT_TO_CUSTOMER("InTransitToCustomer"),
    WITH_CUSTOMER("WithCustomer"),
    IN_TRANSIT_TO_AWS("InTransitToAWS"),
    WITH_AWS_SORTING_FACILITY("WithAWSSortingFacility"),
    WITH_AWS("WithAWS"),
    IN_PROGRESS("InProgress"),
    COMPLETE("Complete"),
    CANCELLED("Cancelled"),
    LISTING("Listing"),
    PENDING("Pending"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, JobState> VALUE_MAP;
    private final String value;

    private JobState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JobState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JobState> knownValues() {
        EnumSet<JobState> knownValues = EnumSet.allOf(JobState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(JobState.class, JobState::toString);
    }
}

