/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLongTermPricingRequest extends SnowballRequest implements
        ToCopyableBuilder<UpdateLongTermPricingRequest.Builder, UpdateLongTermPricingRequest> {
    private static final SdkField<String> LONG_TERM_PRICING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LongTermPricingId").getter(getter(UpdateLongTermPricingRequest::longTermPricingId))
            .setter(setter(Builder::longTermPricingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongTermPricingId").build()).build();

    private static final SdkField<String> REPLACEMENT_JOB_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplacementJob").getter(getter(UpdateLongTermPricingRequest::replacementJob))
            .setter(setter(Builder::replacementJob))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplacementJob").build()).build();

    private static final SdkField<Boolean> IS_LONG_TERM_PRICING_AUTO_RENEW_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsLongTermPricingAutoRenew")
            .getter(getter(UpdateLongTermPricingRequest::isLongTermPricingAutoRenew))
            .setter(setter(Builder::isLongTermPricingAutoRenew))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsLongTermPricingAutoRenew").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LONG_TERM_PRICING_ID_FIELD,
            REPLACEMENT_JOB_FIELD, IS_LONG_TERM_PRICING_AUTO_RENEW_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String longTermPricingId;

    private final String replacementJob;

    private final Boolean isLongTermPricingAutoRenew;

    private UpdateLongTermPricingRequest(BuilderImpl builder) {
        super(builder);
        this.longTermPricingId = builder.longTermPricingId;
        this.replacementJob = builder.replacementJob;
        this.isLongTermPricingAutoRenew = builder.isLongTermPricingAutoRenew;
    }

    /**
     * <p>
     * The ID of the long-term pricing type for the device.
     * </p>
     * 
     * @return The ID of the long-term pricing type for the device.
     */
    public final String longTermPricingId() {
        return longTermPricingId;
    }

    /**
     * <p>
     * Specifies that a device that is ordered with long-term pricing should be replaced with a new device.
     * </p>
     * 
     * @return Specifies that a device that is ordered with long-term pricing should be replaced with a new device.
     */
    public final String replacementJob() {
        return replacementJob;
    }

    /**
     * <p>
     * If set to <code>true</code>, specifies that the current long-term pricing type for the device should be
     * automatically renewed before the long-term pricing contract expires.
     * </p>
     * 
     * @return If set to <code>true</code>, specifies that the current long-term pricing type for the device should be
     *         automatically renewed before the long-term pricing contract expires.
     */
    public final Boolean isLongTermPricingAutoRenew() {
        return isLongTermPricingAutoRenew;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(longTermPricingId());
        hashCode = 31 * hashCode + Objects.hashCode(replacementJob());
        hashCode = 31 * hashCode + Objects.hashCode(isLongTermPricingAutoRenew());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLongTermPricingRequest)) {
            return false;
        }
        UpdateLongTermPricingRequest other = (UpdateLongTermPricingRequest) obj;
        return Objects.equals(longTermPricingId(), other.longTermPricingId())
                && Objects.equals(replacementJob(), other.replacementJob())
                && Objects.equals(isLongTermPricingAutoRenew(), other.isLongTermPricingAutoRenew());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLongTermPricingRequest").add("LongTermPricingId", longTermPricingId())
                .add("ReplacementJob", replacementJob()).add("IsLongTermPricingAutoRenew", isLongTermPricingAutoRenew()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LongTermPricingId":
            return Optional.ofNullable(clazz.cast(longTermPricingId()));
        case "ReplacementJob":
            return Optional.ofNullable(clazz.cast(replacementJob()));
        case "IsLongTermPricingAutoRenew":
            return Optional.ofNullable(clazz.cast(isLongTermPricingAutoRenew()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LongTermPricingId", LONG_TERM_PRICING_ID_FIELD);
        map.put("ReplacementJob", REPLACEMENT_JOB_FIELD);
        map.put("IsLongTermPricingAutoRenew", IS_LONG_TERM_PRICING_AUTO_RENEW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLongTermPricingRequest, T> g) {
        return obj -> g.apply((UpdateLongTermPricingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowballRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLongTermPricingRequest> {
        /**
         * <p>
         * The ID of the long-term pricing type for the device.
         * </p>
         * 
         * @param longTermPricingId
         *        The ID of the long-term pricing type for the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longTermPricingId(String longTermPricingId);

        /**
         * <p>
         * Specifies that a device that is ordered with long-term pricing should be replaced with a new device.
         * </p>
         * 
         * @param replacementJob
         *        Specifies that a device that is ordered with long-term pricing should be replaced with a new device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replacementJob(String replacementJob);

        /**
         * <p>
         * If set to <code>true</code>, specifies that the current long-term pricing type for the device should be
         * automatically renewed before the long-term pricing contract expires.
         * </p>
         * 
         * @param isLongTermPricingAutoRenew
         *        If set to <code>true</code>, specifies that the current long-term pricing type for the device should
         *        be automatically renewed before the long-term pricing contract expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isLongTermPricingAutoRenew(Boolean isLongTermPricingAutoRenew);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnowballRequest.BuilderImpl implements Builder {
        private String longTermPricingId;

        private String replacementJob;

        private Boolean isLongTermPricingAutoRenew;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLongTermPricingRequest model) {
            super(model);
            longTermPricingId(model.longTermPricingId);
            replacementJob(model.replacementJob);
            isLongTermPricingAutoRenew(model.isLongTermPricingAutoRenew);
        }

        public final String getLongTermPricingId() {
            return longTermPricingId;
        }

        public final void setLongTermPricingId(String longTermPricingId) {
            this.longTermPricingId = longTermPricingId;
        }

        @Override
        public final Builder longTermPricingId(String longTermPricingId) {
            this.longTermPricingId = longTermPricingId;
            return this;
        }

        public final String getReplacementJob() {
            return replacementJob;
        }

        public final void setReplacementJob(String replacementJob) {
            this.replacementJob = replacementJob;
        }

        @Override
        public final Builder replacementJob(String replacementJob) {
            this.replacementJob = replacementJob;
            return this;
        }

        public final Boolean getIsLongTermPricingAutoRenew() {
            return isLongTermPricingAutoRenew;
        }

        public final void setIsLongTermPricingAutoRenew(Boolean isLongTermPricingAutoRenew) {
            this.isLongTermPricingAutoRenew = isLongTermPricingAutoRenew;
        }

        @Override
        public final Builder isLongTermPricingAutoRenew(Boolean isLongTermPricingAutoRenew) {
            this.isLongTermPricingAutoRenew = isLongTermPricingAutoRenew;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLongTermPricingRequest build() {
            return new UpdateLongTermPricingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
