/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the metadata and configuration settings for the NFS (Network File System) service on an
 * Amazon Web Services Snow Family device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NFSOnDeviceServiceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NFSOnDeviceServiceConfiguration.Builder, NFSOnDeviceServiceConfiguration> {
    private static final SdkField<Integer> STORAGE_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StorageLimit").getter(getter(NFSOnDeviceServiceConfiguration::storageLimit))
            .setter(setter(Builder::storageLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLimit").build()).build();

    private static final SdkField<String> STORAGE_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageUnit").getter(getter(NFSOnDeviceServiceConfiguration::storageUnitAsString))
            .setter(setter(Builder::storageUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageUnit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_LIMIT_FIELD,
            STORAGE_UNIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer storageLimit;

    private final String storageUnit;

    private NFSOnDeviceServiceConfiguration(BuilderImpl builder) {
        this.storageLimit = builder.storageLimit;
        this.storageUnit = builder.storageUnit;
    }

    /**
     * <p>
     * The maximum NFS storage for one Snow Family device.
     * </p>
     * 
     * @return The maximum NFS storage for one Snow Family device.
     */
    public final Integer storageLimit() {
        return storageLimit;
    }

    /**
     * <p>
     * The scale unit of the NFS storage on the device.
     * </p>
     * <p>
     * Valid values: TB.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageUnit} will
     * return {@link StorageUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageUnitAsString}.
     * </p>
     * 
     * @return The scale unit of the NFS storage on the device.</p>
     *         <p>
     *         Valid values: TB.
     * @see StorageUnit
     */
    public final StorageUnit storageUnit() {
        return StorageUnit.fromValue(storageUnit);
    }

    /**
     * <p>
     * The scale unit of the NFS storage on the device.
     * </p>
     * <p>
     * Valid values: TB.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageUnit} will
     * return {@link StorageUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageUnitAsString}.
     * </p>
     * 
     * @return The scale unit of the NFS storage on the device.</p>
     *         <p>
     *         Valid values: TB.
     * @see StorageUnit
     */
    public final String storageUnitAsString() {
        return storageUnit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storageLimit());
        hashCode = 31 * hashCode + Objects.hashCode(storageUnitAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NFSOnDeviceServiceConfiguration)) {
            return false;
        }
        NFSOnDeviceServiceConfiguration other = (NFSOnDeviceServiceConfiguration) obj;
        return Objects.equals(storageLimit(), other.storageLimit())
                && Objects.equals(storageUnitAsString(), other.storageUnitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NFSOnDeviceServiceConfiguration").add("StorageLimit", storageLimit())
                .add("StorageUnit", storageUnitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageLimit":
            return Optional.ofNullable(clazz.cast(storageLimit()));
        case "StorageUnit":
            return Optional.ofNullable(clazz.cast(storageUnitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StorageLimit", STORAGE_LIMIT_FIELD);
        map.put("StorageUnit", STORAGE_UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NFSOnDeviceServiceConfiguration, T> g) {
        return obj -> g.apply((NFSOnDeviceServiceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NFSOnDeviceServiceConfiguration> {
        /**
         * <p>
         * The maximum NFS storage for one Snow Family device.
         * </p>
         * 
         * @param storageLimit
         *        The maximum NFS storage for one Snow Family device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLimit(Integer storageLimit);

        /**
         * <p>
         * The scale unit of the NFS storage on the device.
         * </p>
         * <p>
         * Valid values: TB.
         * </p>
         * 
         * @param storageUnit
         *        The scale unit of the NFS storage on the device.</p>
         *        <p>
         *        Valid values: TB.
         * @see StorageUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageUnit
         */
        Builder storageUnit(String storageUnit);

        /**
         * <p>
         * The scale unit of the NFS storage on the device.
         * </p>
         * <p>
         * Valid values: TB.
         * </p>
         * 
         * @param storageUnit
         *        The scale unit of the NFS storage on the device.</p>
         *        <p>
         *        Valid values: TB.
         * @see StorageUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageUnit
         */
        Builder storageUnit(StorageUnit storageUnit);
    }

    static final class BuilderImpl implements Builder {
        private Integer storageLimit;

        private String storageUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(NFSOnDeviceServiceConfiguration model) {
            storageLimit(model.storageLimit);
            storageUnit(model.storageUnit);
        }

        public final Integer getStorageLimit() {
            return storageLimit;
        }

        public final void setStorageLimit(Integer storageLimit) {
            this.storageLimit = storageLimit;
        }

        @Override
        public final Builder storageLimit(Integer storageLimit) {
            this.storageLimit = storageLimit;
            return this;
        }

        public final String getStorageUnit() {
            return storageUnit;
        }

        public final void setStorageUnit(String storageUnit) {
            this.storageUnit = storageUnit;
        }

        @Override
        public final Builder storageUnit(String storageUnit) {
            this.storageUnit = storageUnit;
            return this;
        }

        @Override
        public final Builder storageUnit(StorageUnit storageUnit) {
            this.storageUnit(storageUnit == null ? null : storageUnit.toString());
            return this;
        }

        @Override
        public NFSOnDeviceServiceConfiguration build() {
            return new NFSOnDeviceServiceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
