/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceVersionsResponse extends SnowballResponse implements
        ToCopyableBuilder<ListServiceVersionsResponse.Builder, ListServiceVersionsResponse> {
    private static final SdkField<List<ServiceVersion>> SERVICE_VERSIONS_FIELD = SdkField
            .<List<ServiceVersion>> builder(MarshallingType.LIST)
            .memberName("ServiceVersions")
            .getter(getter(ListServiceVersionsResponse::serviceVersions))
            .setter(setter(Builder::serviceVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(ListServiceVersionsResponse::serviceNameAsString))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<List<DependentService>> DEPENDENT_SERVICES_FIELD = SdkField
            .<List<DependentService>> builder(MarshallingType.LIST)
            .memberName("DependentServices")
            .getter(getter(ListServiceVersionsResponse::dependentServices))
            .setter(setter(Builder::dependentServices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependentServices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DependentService> builder(MarshallingType.SDK_POJO)
                                            .constructor(DependentService::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListServiceVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_VERSIONS_FIELD,
            SERVICE_NAME_FIELD, DEPENDENT_SERVICES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ServiceVersion> serviceVersions;

    private final String serviceName;

    private final List<DependentService> dependentServices;

    private final String nextToken;

    private ListServiceVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.serviceVersions = builder.serviceVersions;
        this.serviceName = builder.serviceName;
        this.dependentServices = builder.dependentServices;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceVersions() {
        return serviceVersions != null && !(serviceVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of supported versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceVersions} method.
     * </p>
     * 
     * @return A list of supported versions.
     */
    public final List<ServiceVersion> serviceVersions() {
        return serviceVersions;
    }

    /**
     * <p>
     * The name of the service for which the system provided supported versions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceName} will
     * return {@link ServiceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceNameAsString}.
     * </p>
     * 
     * @return The name of the service for which the system provided supported versions.
     * @see ServiceName
     */
    public final ServiceName serviceName() {
        return ServiceName.fromValue(serviceName);
    }

    /**
     * <p>
     * The name of the service for which the system provided supported versions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceName} will
     * return {@link ServiceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceNameAsString}.
     * </p>
     * 
     * @return The name of the service for which the system provided supported versions.
     * @see ServiceName
     */
    public final String serviceNameAsString() {
        return serviceName;
    }

    /**
     * For responses, this returns true if the service returned a value for the DependentServices property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDependentServices() {
        return dependentServices != null && !(dependentServices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of names and versions of dependant services of the service for which the system provided supported
     * versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDependentServices} method.
     * </p>
     * 
     * @return A list of names and versions of dependant services of the service for which the system provided supported
     *         versions.
     */
    public final List<DependentService> dependentServices() {
        return dependentServices;
    }

    /**
     * <p>
     * Because HTTP requests are stateless, this is the starting point of the next list of returned
     * <code>ListServiceVersionsResult</code> results.
     * </p>
     * 
     * @return Because HTTP requests are stateless, this is the starting point of the next list of returned
     *         <code>ListServiceVersionsResult</code> results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceVersions() ? serviceVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDependentServices() ? dependentServices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceVersionsResponse)) {
            return false;
        }
        ListServiceVersionsResponse other = (ListServiceVersionsResponse) obj;
        return hasServiceVersions() == other.hasServiceVersions() && Objects.equals(serviceVersions(), other.serviceVersions())
                && Objects.equals(serviceNameAsString(), other.serviceNameAsString())
                && hasDependentServices() == other.hasDependentServices()
                && Objects.equals(dependentServices(), other.dependentServices())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServiceVersionsResponse")
                .add("ServiceVersions", hasServiceVersions() ? serviceVersions() : null)
                .add("ServiceName", serviceNameAsString())
                .add("DependentServices", hasDependentServices() ? dependentServices() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceVersions":
            return Optional.ofNullable(clazz.cast(serviceVersions()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceNameAsString()));
        case "DependentServices":
            return Optional.ofNullable(clazz.cast(dependentServices()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServiceVersions", SERVICE_VERSIONS_FIELD);
        map.put("ServiceName", SERVICE_NAME_FIELD);
        map.put("DependentServices", DEPENDENT_SERVICES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServiceVersionsResponse, T> g) {
        return obj -> g.apply((ListServiceVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowballResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListServiceVersionsResponse> {
        /**
         * <p>
         * A list of supported versions.
         * </p>
         * 
         * @param serviceVersions
         *        A list of supported versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceVersions(Collection<ServiceVersion> serviceVersions);

        /**
         * <p>
         * A list of supported versions.
         * </p>
         * 
         * @param serviceVersions
         *        A list of supported versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceVersions(ServiceVersion... serviceVersions);

        /**
         * <p>
         * A list of supported versions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.snowball.model.ServiceVersion.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.snowball.model.ServiceVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.snowball.model.ServiceVersion.Builder#build()} is called immediately
         * and its result is passed to {@link #serviceVersions(List<ServiceVersion>)}.
         * 
         * @param serviceVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.snowball.model.ServiceVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceVersions(java.util.Collection<ServiceVersion>)
         */
        Builder serviceVersions(Consumer<ServiceVersion.Builder>... serviceVersions);

        /**
         * <p>
         * The name of the service for which the system provided supported versions.
         * </p>
         * 
         * @param serviceName
         *        The name of the service for which the system provided supported versions.
         * @see ServiceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceName
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The name of the service for which the system provided supported versions.
         * </p>
         * 
         * @param serviceName
         *        The name of the service for which the system provided supported versions.
         * @see ServiceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceName
         */
        Builder serviceName(ServiceName serviceName);

        /**
         * <p>
         * A list of names and versions of dependant services of the service for which the system provided supported
         * versions.
         * </p>
         * 
         * @param dependentServices
         *        A list of names and versions of dependant services of the service for which the system provided
         *        supported versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependentServices(Collection<DependentService> dependentServices);

        /**
         * <p>
         * A list of names and versions of dependant services of the service for which the system provided supported
         * versions.
         * </p>
         * 
         * @param dependentServices
         *        A list of names and versions of dependant services of the service for which the system provided
         *        supported versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependentServices(DependentService... dependentServices);

        /**
         * <p>
         * A list of names and versions of dependant services of the service for which the system provided supported
         * versions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.snowball.model.DependentService.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.snowball.model.DependentService#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.snowball.model.DependentService.Builder#build()} is called immediately
         * and its result is passed to {@link #dependentServices(List<DependentService>)}.
         * 
         * @param dependentServices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.snowball.model.DependentService.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dependentServices(java.util.Collection<DependentService>)
         */
        Builder dependentServices(Consumer<DependentService.Builder>... dependentServices);

        /**
         * <p>
         * Because HTTP requests are stateless, this is the starting point of the next list of returned
         * <code>ListServiceVersionsResult</code> results.
         * </p>
         * 
         * @param nextToken
         *        Because HTTP requests are stateless, this is the starting point of the next list of returned
         *        <code>ListServiceVersionsResult</code> results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SnowballResponse.BuilderImpl implements Builder {
        private List<ServiceVersion> serviceVersions = DefaultSdkAutoConstructList.getInstance();

        private String serviceName;

        private List<DependentService> dependentServices = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceVersionsResponse model) {
            super(model);
            serviceVersions(model.serviceVersions);
            serviceName(model.serviceName);
            dependentServices(model.dependentServices);
            nextToken(model.nextToken);
        }

        public final List<ServiceVersion.Builder> getServiceVersions() {
            List<ServiceVersion.Builder> result = ServiceVersionListCopier.copyToBuilder(this.serviceVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceVersions(Collection<ServiceVersion.BuilderImpl> serviceVersions) {
            this.serviceVersions = ServiceVersionListCopier.copyFromBuilder(serviceVersions);
        }

        @Override
        public final Builder serviceVersions(Collection<ServiceVersion> serviceVersions) {
            this.serviceVersions = ServiceVersionListCopier.copy(serviceVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceVersions(ServiceVersion... serviceVersions) {
            serviceVersions(Arrays.asList(serviceVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceVersions(Consumer<ServiceVersion.Builder>... serviceVersions) {
            serviceVersions(Stream.of(serviceVersions).map(c -> ServiceVersion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public final Builder serviceName(ServiceName serviceName) {
            this.serviceName(serviceName == null ? null : serviceName.toString());
            return this;
        }

        public final List<DependentService.Builder> getDependentServices() {
            List<DependentService.Builder> result = DependentServiceListCopier.copyToBuilder(this.dependentServices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDependentServices(Collection<DependentService.BuilderImpl> dependentServices) {
            this.dependentServices = DependentServiceListCopier.copyFromBuilder(dependentServices);
        }

        @Override
        public final Builder dependentServices(Collection<DependentService> dependentServices) {
            this.dependentServices = DependentServiceListCopier.copy(dependentServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependentServices(DependentService... dependentServices) {
            dependentServices(Arrays.asList(dependentServices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependentServices(Consumer<DependentService.Builder>... dependentServices) {
            dependentServices(Stream.of(dependentServices).map(c -> DependentService.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListServiceVersionsResponse build() {
            return new ListServiceVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
