/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates whether the job
 * is a job part, in the case of an export job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobListEntry implements SdkPojo, Serializable, ToCopyableBuilder<JobListEntry.Builder, JobListEntry> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(JobListEntry::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> JOB_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobState").getter(getter(JobListEntry::jobStateAsString)).setter(setter(Builder::jobState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobState").build()).build();

    private static final SdkField<Boolean> IS_MASTER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsMaster").getter(getter(JobListEntry::isMaster)).setter(setter(Builder::isMaster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsMaster").build()).build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobType").getter(getter(JobListEntry::jobTypeAsString)).setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()).build();

    private static final SdkField<String> SNOWBALL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnowballType").getter(getter(JobListEntry::snowballTypeAsString)).setter(setter(Builder::snowballType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowballType").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(JobListEntry::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(JobListEntry::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_STATE_FIELD,
            IS_MASTER_FIELD, JOB_TYPE_FIELD, SNOWBALL_TYPE_FIELD, CREATION_DATE_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final String jobState;

    private final Boolean isMaster;

    private final String jobType;

    private final String snowballType;

    private final Instant creationDate;

    private final String description;

    private JobListEntry(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobState = builder.jobState;
        this.isMaster = builder.isMaster;
        this.jobType = builder.jobType;
        this.snowballType = builder.snowballType;
        this.creationDate = builder.creationDate;
        this.description = builder.description;
    }

    /**
     * <p>
     * The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
     * </p>
     * 
     * @return The automatically generated ID for a job, for example
     *         <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The current state of this job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobState} will
     * return {@link JobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStateAsString}.
     * </p>
     * 
     * @return The current state of this job.
     * @see JobState
     */
    public final JobState jobState() {
        return JobState.fromValue(jobState);
    }

    /**
     * <p>
     * The current state of this job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobState} will
     * return {@link JobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStateAsString}.
     * </p>
     * 
     * @return The current state of this job.
     * @see JobState
     */
    public final String jobStateAsString() {
        return jobState;
    }

    /**
     * <p>
     * A value that indicates that this job is a main job. A main job represents a successful request to create an
     * export job. Main jobs aren't associated with any Snowballs. Instead, each main job will have at least one job
     * part, and each job part is associated with a Snowball. It might take some time before the job parts associated
     * with a particular main job are listed, because they are created after the main job is created.
     * </p>
     * 
     * @return A value that indicates that this job is a main job. A main job represents a successful request to create
     *         an export job. Main jobs aren't associated with any Snowballs. Instead, each main job will have at least
     *         one job part, and each job part is associated with a Snowball. It might take some time before the job
     *         parts associated with a particular main job are listed, because they are created after the main job is
     *         created.
     */
    public final Boolean isMaster() {
        return isMaster;
    }

    /**
     * <p>
     * The type of job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The type of job.
     * @see JobType
     */
    public final JobType jobType() {
        return JobType.fromValue(jobType);
    }

    /**
     * <p>
     * The type of job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The type of job.
     * @see JobType
     */
    public final String jobTypeAsString() {
        return jobType;
    }

    /**
     * <p>
     * The type of device used with this job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #snowballType} will
     * return {@link SnowballType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #snowballTypeAsString}.
     * </p>
     * 
     * @return The type of device used with this job.
     * @see SnowballType
     */
    public final SnowballType snowballType() {
        return SnowballType.fromValue(snowballType);
    }

    /**
     * <p>
     * The type of device used with this job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #snowballType} will
     * return {@link SnowballType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #snowballTypeAsString}.
     * </p>
     * 
     * @return The type of device used with this job.
     * @see SnowballType
     */
    public final String snowballTypeAsString() {
        return snowballType;
    }

    /**
     * <p>
     * The creation date for this job.
     * </p>
     * 
     * @return The creation date for this job.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.
     * </p>
     * 
     * @return The optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isMaster());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(snowballTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobListEntry)) {
            return false;
        }
        JobListEntry other = (JobListEntry) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(jobStateAsString(), other.jobStateAsString())
                && Objects.equals(isMaster(), other.isMaster()) && Objects.equals(jobTypeAsString(), other.jobTypeAsString())
                && Objects.equals(snowballTypeAsString(), other.snowballTypeAsString())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobListEntry").add("JobId", jobId()).add("JobState", jobStateAsString())
                .add("IsMaster", isMaster()).add("JobType", jobTypeAsString()).add("SnowballType", snowballTypeAsString())
                .add("CreationDate", creationDate()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "JobState":
            return Optional.ofNullable(clazz.cast(jobStateAsString()));
        case "IsMaster":
            return Optional.ofNullable(clazz.cast(isMaster()));
        case "JobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        case "SnowballType":
            return Optional.ofNullable(clazz.cast(snowballTypeAsString()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobId", JOB_ID_FIELD);
        map.put("JobState", JOB_STATE_FIELD);
        map.put("IsMaster", IS_MASTER_FIELD);
        map.put("JobType", JOB_TYPE_FIELD);
        map.put("SnowballType", SNOWBALL_TYPE_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobListEntry, T> g) {
        return obj -> g.apply((JobListEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobListEntry> {
        /**
         * <p>
         * The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
         * </p>
         * 
         * @param jobId
         *        The automatically generated ID for a job, for example
         *        <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The current state of this job.
         * </p>
         * 
         * @param jobState
         *        The current state of this job.
         * @see JobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobState
         */
        Builder jobState(String jobState);

        /**
         * <p>
         * The current state of this job.
         * </p>
         * 
         * @param jobState
         *        The current state of this job.
         * @see JobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobState
         */
        Builder jobState(JobState jobState);

        /**
         * <p>
         * A value that indicates that this job is a main job. A main job represents a successful request to create an
         * export job. Main jobs aren't associated with any Snowballs. Instead, each main job will have at least one job
         * part, and each job part is associated with a Snowball. It might take some time before the job parts
         * associated with a particular main job are listed, because they are created after the main job is created.
         * </p>
         * 
         * @param isMaster
         *        A value that indicates that this job is a main job. A main job represents a successful request to
         *        create an export job. Main jobs aren't associated with any Snowballs. Instead, each main job will have
         *        at least one job part, and each job part is associated with a Snowball. It might take some time before
         *        the job parts associated with a particular main job are listed, because they are created after the
         *        main job is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isMaster(Boolean isMaster);

        /**
         * <p>
         * The type of job.
         * </p>
         * 
         * @param jobType
         *        The type of job.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * The type of job.
         * </p>
         * 
         * @param jobType
         *        The type of job.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);

        /**
         * <p>
         * The type of device used with this job.
         * </p>
         * 
         * @param snowballType
         *        The type of device used with this job.
         * @see SnowballType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballType
         */
        Builder snowballType(String snowballType);

        /**
         * <p>
         * The type of device used with this job.
         * </p>
         * 
         * @param snowballType
         *        The type of device used with this job.
         * @see SnowballType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballType
         */
        Builder snowballType(SnowballType snowballType);

        /**
         * <p>
         * The creation date for this job.
         * </p>
         * 
         * @param creationDate
         *        The creation date for this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.
         * </p>
         * 
         * @param description
         *        The optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String jobState;

        private Boolean isMaster;

        private String jobType;

        private String snowballType;

        private Instant creationDate;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(JobListEntry model) {
            jobId(model.jobId);
            jobState(model.jobState);
            isMaster(model.isMaster);
            jobType(model.jobType);
            snowballType(model.snowballType);
            creationDate(model.creationDate);
            description(model.description);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobState() {
            return jobState;
        }

        public final void setJobState(String jobState) {
            this.jobState = jobState;
        }

        @Override
        public final Builder jobState(String jobState) {
            this.jobState = jobState;
            return this;
        }

        @Override
        public final Builder jobState(JobState jobState) {
            this.jobState(jobState == null ? null : jobState.toString());
            return this;
        }

        public final Boolean getIsMaster() {
            return isMaster;
        }

        public final void setIsMaster(Boolean isMaster) {
            this.isMaster = isMaster;
        }

        @Override
        public final Builder isMaster(Boolean isMaster) {
            this.isMaster = isMaster;
            return this;
        }

        public final String getJobType() {
            return jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final String getSnowballType() {
            return snowballType;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType == null ? null : snowballType.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public JobListEntry build() {
            return new JobListEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
