/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.model.UpdateClusterRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateClusterRequestModelMarshaller {
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Resources").isBinary(false).build();
    private static final MarshallingInfo<String> ADDRESSID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddressId").isBinary(false).build();
    private static final MarshallingInfo<String> SHIPPINGOPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShippingOption").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NOTIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Notification").isBinary(false).build();
    private static final MarshallingInfo<String> FORWARDINGADDRESSID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ForwardingAddressId").isBinary(false).build();
    private static final UpdateClusterRequestModelMarshaller INSTANCE = new UpdateClusterRequestModelMarshaller();

    private UpdateClusterRequestModelMarshaller() {
    }

    public static UpdateClusterRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateClusterRequest updateClusterRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateClusterRequest), (String)"updateClusterRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateClusterRequest.clusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall((Object)updateClusterRequest.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)updateClusterRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)updateClusterRequest.resources(), RESOURCES_BINDING);
            protocolMarshaller.marshall((Object)updateClusterRequest.addressId(), ADDRESSID_BINDING);
            protocolMarshaller.marshall((Object)updateClusterRequest.shippingOptionAsString(), SHIPPINGOPTION_BINDING);
            protocolMarshaller.marshall((Object)updateClusterRequest.notification(), NOTIFICATION_BINDING);
            protocolMarshaller.marshall((Object)updateClusterRequest.forwardingAddressId(), FORWARDINGADDRESSID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

