/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.snowball.model.Shipment;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ShipmentMarshaller {
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> TRACKINGNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrackingNumber").isBinary(false).build();
    private static final ShipmentMarshaller INSTANCE = new ShipmentMarshaller();

    private ShipmentMarshaller() {
    }

    public static ShipmentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Shipment shipment, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)shipment, (String)"shipment");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)shipment.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)shipment.trackingNumber(), TRACKINGNUMBER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

