/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.snowball.model.ListCompatibleImagesRequest;
import software.amazon.awssdk.services.snowball.transform.ListCompatibleImagesRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListCompatibleImagesRequestMarshaller
implements Marshaller<Request<ListCompatibleImagesRequest>, ListCompatibleImagesRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AWSIESnowballJobManagementService.ListCompatibleImages").serviceName("Amazon Snowball").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public ListCompatibleImagesRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListCompatibleImagesRequest> marshall(ListCompatibleImagesRequest listCompatibleImagesRequest) {
        Validate.paramNotNull((Object)((Object)listCompatibleImagesRequest), (String)"listCompatibleImagesRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)listCompatibleImagesRequest);
            protocolMarshaller.startMarshalling();
            ListCompatibleImagesRequestModelMarshaller.getInstance().marshall(listCompatibleImagesRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

