/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.snowball.model.Ec2AmiResource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class Ec2AmiResourceMarshaller {
    private static final MarshallingInfo<String> AMIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AmiId").isBinary(false).build();
    private static final MarshallingInfo<String> SNOWBALLAMIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnowballAmiId").isBinary(false).build();
    private static final Ec2AmiResourceMarshaller INSTANCE = new Ec2AmiResourceMarshaller();

    private Ec2AmiResourceMarshaller() {
    }

    public static Ec2AmiResourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Ec2AmiResource ec2AmiResource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ec2AmiResource, (String)"ec2AmiResource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ec2AmiResource.amiId(), AMIID_BINDING);
            protocolMarshaller.marshall((Object)ec2AmiResource.snowballAmiId(), SNOWBALLAMIID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

