/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.snowball.model.CompatibleImage;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CompatibleImageMarshaller {
    private static final MarshallingInfo<String> AMIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AmiId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final CompatibleImageMarshaller INSTANCE = new CompatibleImageMarshaller();

    private CompatibleImageMarshaller() {
    }

    public static CompatibleImageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CompatibleImage compatibleImage, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)compatibleImage, (String)"compatibleImage");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)compatibleImage.amiId(), AMIID_BINDING);
            protocolMarshaller.marshall((Object)compatibleImage.name(), NAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

