/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.snowball.model.CancelClusterRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CancelClusterRequestModelMarshaller {
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").isBinary(false).build();
    private static final CancelClusterRequestModelMarshaller INSTANCE = new CancelClusterRequestModelMarshaller();

    private CancelClusterRequestModelMarshaller() {
    }

    public static CancelClusterRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CancelClusterRequest cancelClusterRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)cancelClusterRequest), (String)"cancelClusterRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)cancelClusterRequest.clusterId(), CLUSTERID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

