/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.snowball.model.SnowballRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAddressRequest
extends SnowballRequest
implements ToCopyableBuilder<Builder, DescribeAddressRequest> {
    private final String addressId;

    private DescribeAddressRequest(BuilderImpl builder) {
        super(builder);
        this.addressId = builder.addressId;
    }

    public String addressId() {
        return this.addressId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.addressId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddressRequest)) {
            return false;
        }
        DescribeAddressRequest other = (DescribeAddressRequest)((Object)obj);
        return Objects.equals(this.addressId(), other.addressId());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAddressRequest").add("AddressId", (Object)this.addressId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddressId": {
                return Optional.ofNullable(clazz.cast(this.addressId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SnowballRequest.BuilderImpl
    implements Builder {
        private String addressId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddressRequest model) {
            super(model);
            this.addressId(model.addressId);
        }

        public final String getAddressId() {
            return this.addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAddressRequest build() {
            return new DescribeAddressRequest(this);
        }
    }

    public static interface Builder
    extends SnowballRequest.Builder,
    CopyableBuilder<Builder, DescribeAddressRequest> {
        public Builder addressId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

