/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.snowball.model.JobResource;
import software.amazon.awssdk.services.snowball.model.JobType;
import software.amazon.awssdk.services.snowball.model.Notification;
import software.amazon.awssdk.services.snowball.model.ShippingOption;
import software.amazon.awssdk.services.snowball.model.SnowballRequest;
import software.amazon.awssdk.services.snowball.model.SnowballType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateClusterRequest
extends SnowballRequest
implements ToCopyableBuilder<Builder, CreateClusterRequest> {
    private final String jobType;
    private final JobResource resources;
    private final String description;
    private final String addressId;
    private final String kmsKeyARN;
    private final String roleARN;
    private final String snowballType;
    private final String shippingOption;
    private final Notification notification;
    private final String forwardingAddressId;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.jobType = builder.jobType;
        this.resources = builder.resources;
        this.description = builder.description;
        this.addressId = builder.addressId;
        this.kmsKeyARN = builder.kmsKeyARN;
        this.roleARN = builder.roleARN;
        this.snowballType = builder.snowballType;
        this.shippingOption = builder.shippingOption;
        this.notification = builder.notification;
        this.forwardingAddressId = builder.forwardingAddressId;
    }

    public JobType jobType() {
        return JobType.fromValue(this.jobType);
    }

    public String jobTypeAsString() {
        return this.jobType;
    }

    public JobResource resources() {
        return this.resources;
    }

    public String description() {
        return this.description;
    }

    public String addressId() {
        return this.addressId;
    }

    public String kmsKeyARN() {
        return this.kmsKeyARN;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public SnowballType snowballType() {
        return SnowballType.fromValue(this.snowballType);
    }

    public String snowballTypeAsString() {
        return this.snowballType;
    }

    public ShippingOption shippingOption() {
        return ShippingOption.fromValue(this.shippingOption);
    }

    public String shippingOptionAsString() {
        return this.shippingOption;
    }

    public Notification notification() {
        return this.notification;
    }

    public String forwardingAddressId() {
        return this.forwardingAddressId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resources());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressId());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.snowballTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shippingOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notification());
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardingAddressId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest)((Object)obj);
        return Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.addressId(), other.addressId()) && Objects.equals(this.kmsKeyARN(), other.kmsKeyARN()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.snowballTypeAsString(), other.snowballTypeAsString()) && Objects.equals(this.shippingOptionAsString(), other.shippingOptionAsString()) && Objects.equals(this.notification(), other.notification()) && Objects.equals(this.forwardingAddressId(), other.forwardingAddressId());
    }

    public String toString() {
        return ToString.builder((String)"CreateClusterRequest").add("JobType", (Object)this.jobTypeAsString()).add("Resources", (Object)this.resources()).add("Description", (Object)this.description()).add("AddressId", (Object)this.addressId()).add("KmsKeyARN", (Object)this.kmsKeyARN()).add("RoleARN", (Object)this.roleARN()).add("SnowballType", (Object)this.snowballTypeAsString()).add("ShippingOption", (Object)this.shippingOptionAsString()).add("Notification", (Object)this.notification()).add("ForwardingAddressId", (Object)this.forwardingAddressId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AddressId": {
                return Optional.ofNullable(clazz.cast(this.addressId()));
            }
            case "KmsKeyARN": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyARN()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "SnowballType": {
                return Optional.ofNullable(clazz.cast(this.snowballTypeAsString()));
            }
            case "ShippingOption": {
                return Optional.ofNullable(clazz.cast(this.shippingOptionAsString()));
            }
            case "Notification": {
                return Optional.ofNullable(clazz.cast(this.notification()));
            }
            case "ForwardingAddressId": {
                return Optional.ofNullable(clazz.cast(this.forwardingAddressId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SnowballRequest.BuilderImpl
    implements Builder {
        private String jobType;
        private JobResource resources;
        private String description;
        private String addressId;
        private String kmsKeyARN;
        private String roleARN;
        private String snowballType;
        private String shippingOption;
        private Notification notification;
        private String forwardingAddressId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            this.jobType(model.jobType);
            this.resources(model.resources);
            this.description(model.description);
            this.addressId(model.addressId);
            this.kmsKeyARN(model.kmsKeyARN);
            this.roleARN(model.roleARN);
            this.snowballType(model.snowballType);
            this.shippingOption(model.shippingOption);
            this.notification(model.notification);
            this.forwardingAddressId(model.forwardingAddressId);
        }

        public final String getJobType() {
            return this.jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final JobResource.Builder getResources() {
            return this.resources != null ? this.resources.toBuilder() : null;
        }

        @Override
        public final Builder resources(JobResource resources) {
            this.resources = resources;
            return this;
        }

        public final void setResources(JobResource.BuilderImpl resources) {
            this.resources = resources != null ? resources.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getAddressId() {
            return this.addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        public final String getKmsKeyARN() {
            return this.kmsKeyARN;
        }

        @Override
        public final Builder kmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
            return this;
        }

        public final void setKmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getSnowballType() {
            return this.snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType.toString());
            return this;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        public final String getShippingOption() {
            return this.shippingOption;
        }

        @Override
        public final Builder shippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        @Override
        public final Builder shippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption.toString());
            return this;
        }

        public final void setShippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
        }

        public final Notification.Builder getNotification() {
            return this.notification != null ? this.notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final String getForwardingAddressId() {
            return this.forwardingAddressId;
        }

        @Override
        public final Builder forwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
            return this;
        }

        public final void setForwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }
    }

    public static interface Builder
    extends SnowballRequest.Builder,
    CopyableBuilder<Builder, CreateClusterRequest> {
        public Builder jobType(String var1);

        public Builder jobType(JobType var1);

        public Builder resources(JobResource var1);

        default public Builder resources(Consumer<JobResource.Builder> resources) {
            return this.resources((JobResource)((JobResource.Builder)JobResource.builder().applyMutation(resources)).build());
        }

        public Builder description(String var1);

        public Builder addressId(String var1);

        public Builder kmsKeyARN(String var1);

        public Builder roleARN(String var1);

        public Builder snowballType(String var1);

        public Builder snowballType(SnowballType var1);

        public Builder shippingOption(String var1);

        public Builder shippingOption(ShippingOption var1);

        public Builder notification(Notification var1);

        default public Builder notification(Consumer<Notification.Builder> notification) {
            return this.notification((Notification)((Notification.Builder)Notification.builder().applyMutation(notification)).build());
        }

        public Builder forwardingAddressId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

