/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.snowball.SnowballAsyncClient;
import software.amazon.awssdk.services.snowball.model.CancelClusterRequest;
import software.amazon.awssdk.services.snowball.model.CancelClusterResponse;
import software.amazon.awssdk.services.snowball.model.CancelJobRequest;
import software.amazon.awssdk.services.snowball.model.CancelJobResponse;
import software.amazon.awssdk.services.snowball.model.ClusterLimitExceededException;
import software.amazon.awssdk.services.snowball.model.CreateAddressRequest;
import software.amazon.awssdk.services.snowball.model.CreateAddressResponse;
import software.amazon.awssdk.services.snowball.model.CreateClusterRequest;
import software.amazon.awssdk.services.snowball.model.CreateClusterResponse;
import software.amazon.awssdk.services.snowball.model.CreateJobRequest;
import software.amazon.awssdk.services.snowball.model.CreateJobResponse;
import software.amazon.awssdk.services.snowball.model.DescribeAddressRequest;
import software.amazon.awssdk.services.snowball.model.DescribeAddressResponse;
import software.amazon.awssdk.services.snowball.model.DescribeAddressesRequest;
import software.amazon.awssdk.services.snowball.model.DescribeAddressesResponse;
import software.amazon.awssdk.services.snowball.model.DescribeClusterRequest;
import software.amazon.awssdk.services.snowball.model.DescribeClusterResponse;
import software.amazon.awssdk.services.snowball.model.DescribeJobRequest;
import software.amazon.awssdk.services.snowball.model.DescribeJobResponse;
import software.amazon.awssdk.services.snowball.model.Ec2RequestFailedException;
import software.amazon.awssdk.services.snowball.model.GetJobManifestRequest;
import software.amazon.awssdk.services.snowball.model.GetJobManifestResponse;
import software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeRequest;
import software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeResponse;
import software.amazon.awssdk.services.snowball.model.GetSnowballUsageRequest;
import software.amazon.awssdk.services.snowball.model.GetSnowballUsageResponse;
import software.amazon.awssdk.services.snowball.model.InvalidAddressException;
import software.amazon.awssdk.services.snowball.model.InvalidInputCombinationException;
import software.amazon.awssdk.services.snowball.model.InvalidJobStateException;
import software.amazon.awssdk.services.snowball.model.InvalidNextTokenException;
import software.amazon.awssdk.services.snowball.model.InvalidResourceException;
import software.amazon.awssdk.services.snowball.model.KmsRequestFailedException;
import software.amazon.awssdk.services.snowball.model.ListClusterJobsRequest;
import software.amazon.awssdk.services.snowball.model.ListClusterJobsResponse;
import software.amazon.awssdk.services.snowball.model.ListClustersRequest;
import software.amazon.awssdk.services.snowball.model.ListClustersResponse;
import software.amazon.awssdk.services.snowball.model.ListCompatibleImagesRequest;
import software.amazon.awssdk.services.snowball.model.ListCompatibleImagesResponse;
import software.amazon.awssdk.services.snowball.model.ListJobsRequest;
import software.amazon.awssdk.services.snowball.model.ListJobsResponse;
import software.amazon.awssdk.services.snowball.model.SnowballException;
import software.amazon.awssdk.services.snowball.model.SnowballRequest;
import software.amazon.awssdk.services.snowball.model.UnsupportedAddressException;
import software.amazon.awssdk.services.snowball.model.UpdateClusterRequest;
import software.amazon.awssdk.services.snowball.model.UpdateClusterResponse;
import software.amazon.awssdk.services.snowball.model.UpdateJobRequest;
import software.amazon.awssdk.services.snowball.model.UpdateJobResponse;
import software.amazon.awssdk.services.snowball.paginators.DescribeAddressesPublisher;
import software.amazon.awssdk.services.snowball.paginators.ListJobsPublisher;
import software.amazon.awssdk.services.snowball.transform.CancelClusterRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.CancelClusterResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.CancelJobRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.CancelJobResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.CreateAddressRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.CreateAddressResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.CreateClusterResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.CreateJobRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.CreateJobResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeAddressRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeAddressResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeAddressesRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeAddressesResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeClusterRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeClusterResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeJobRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeJobResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.GetJobManifestRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.GetJobManifestResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.GetJobUnlockCodeRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.GetJobUnlockCodeResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.GetSnowballUsageRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.GetSnowballUsageResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.ListClusterJobsRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.ListClusterJobsResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.ListClustersRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.ListClustersResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.ListCompatibleImagesRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.ListCompatibleImagesResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.ListJobsResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.UpdateClusterRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.UpdateClusterResponseUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.UpdateJobRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.UpdateJobResponseUnmarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultSnowballAsyncClient
implements SnowballAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultSnowballAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;

    protected DefaultSnowballAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.protocolFactory = this.init(false);
    }

    public final String serviceName() {
        return "snowball";
    }

    @Override
    public CompletableFuture<CancelClusterResponse> cancelCluster(CancelClusterRequest cancelClusterRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelClusterResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CancelClusterRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelClusterRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CancelJobResponse> cancelJob(CancelJobRequest cancelJobRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelJobResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CancelJobRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelJobRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateAddressResponse> createAddress(CreateAddressRequest createAddressRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAddressResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateAddressRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAddressRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateClusterResponse> createCluster(CreateClusterRequest createClusterRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateClusterResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateClusterRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createClusterRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateJobResponse> createJob(CreateJobRequest createJobRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateJobResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateJobRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createJobRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAddressResponse> describeAddress(DescribeAddressRequest describeAddressRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAddressResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeAddressRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAddressRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAddressesResponse> describeAddresses(DescribeAddressesRequest describeAddressesRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAddressesResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeAddressesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAddressesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeAddressesPublisher describeAddressesPaginator(DescribeAddressesRequest describeAddressesRequest) {
        return new DescribeAddressesPublisher(this, this.applyPaginatorUserAgent(describeAddressesRequest));
    }

    @Override
    public CompletableFuture<DescribeClusterResponse> describeCluster(DescribeClusterRequest describeClusterRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeClusterResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeClusterRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeClusterRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeJobResponse> describeJob(DescribeJobRequest describeJobRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeJobResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeJobRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeJobRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetJobManifestResponse> getJobManifest(GetJobManifestRequest getJobManifestRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetJobManifestResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetJobManifestRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getJobManifestRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetJobUnlockCodeResponse> getJobUnlockCode(GetJobUnlockCodeRequest getJobUnlockCodeRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetJobUnlockCodeResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetJobUnlockCodeRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getJobUnlockCodeRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSnowballUsageResponse> getSnowballUsage(GetSnowballUsageRequest getSnowballUsageRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSnowballUsageResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetSnowballUsageRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSnowballUsageRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListClusterJobsResponse> listClusterJobs(ListClusterJobsRequest listClusterJobsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListClusterJobsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListClusterJobsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listClusterJobsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListClustersResponse> listClusters(ListClustersRequest listClustersRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListClustersResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListClustersRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listClustersRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCompatibleImagesResponse> listCompatibleImages(ListCompatibleImagesRequest listCompatibleImagesRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListCompatibleImagesResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListCompatibleImagesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCompatibleImagesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListJobsResponse> listJobs(ListJobsRequest listJobsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListJobsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListJobsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listJobsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListJobsPublisher listJobsPaginator(ListJobsRequest listJobsRequest) {
        return new ListJobsPublisher(this, this.applyPaginatorUserAgent(listJobsRequest));
    }

    @Override
    public CompletableFuture<UpdateClusterResponse> updateCluster(UpdateClusterRequest updateClusterRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateClusterResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateClusterRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateClusterRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateJobResponse> updateJob(UpdateJobRequest updateJobRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateJobResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateJobRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateJobRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(supportsCbor).withSupportsIon(false).withBaseServiceExceptionClass(SnowballException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidJobStateException").withModeledClass(InvalidJobStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidResourceException").withModeledClass(InvalidResourceException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedAddressException").withModeledClass(UnsupportedAddressException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClusterLimitExceededException").withModeledClass(ClusterLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInputCombinationException").withModeledClass(InvalidInputCombinationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("Ec2RequestFailedException").withModeledClass(Ec2RequestFailedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSRequestFailedException").withModeledClass(KmsRequestFailedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidAddressException").withModeledClass(InvalidAddressException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    private <T extends SnowballRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.0.0-preview-12").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((SnowballRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}

