/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.snowball.model.DataTransfer;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link DataTransfer} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class DataTransferMarshaller {
    private static final MarshallingInfo<Long> BYTESTRANSFERRED_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BytesTransferred").isBinary(false).build();

    private static final MarshallingInfo<Long> OBJECTSTRANSFERRED_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectsTransferred").isBinary(false).build();

    private static final MarshallingInfo<Long> TOTALBYTES_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalBytes").isBinary(false).build();

    private static final MarshallingInfo<Long> TOTALOBJECTS_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalObjects").isBinary(false).build();

    private static final DataTransferMarshaller INSTANCE = new DataTransferMarshaller();

    private DataTransferMarshaller() {
    }

    public static DataTransferMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(DataTransfer dataTransfer, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(dataTransfer, "dataTransfer");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(dataTransfer.bytesTransferred(), BYTESTRANSFERRED_BINDING);
            protocolMarshaller.marshall(dataTransfer.objectsTransferred(), OBJECTSTRANSFERRED_BINDING);
            protocolMarshaller.marshall(dataTransfer.totalBytes(), TOTALBYTES_BINDING);
            protocolMarshaller.marshall(dataTransfer.totalObjects(), TOTALOBJECTS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
