/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The specified resource can't be found. Check the information you provided in your last request, and try again.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidResourceException extends SnowballException implements
        ToCopyableBuilder<InvalidResourceException.Builder, InvalidResourceException> {
    private final String resourceType;

    private InvalidResourceException(BuilderImpl builder) {
        super(builder);
        this.resourceType = builder.resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The provided resource value is invalid.
     * </p>
     * 
     * @return The provided resource value is invalid.
     */
    public String resourceType() {
        return resourceType;
    }

    public interface Builder extends CopyableBuilder<Builder, InvalidResourceException>, SnowballException.Builder {
        /**
         * <p>
         * The provided resource value is invalid.
         * </p>
         * 
         * @param resourceType
         *        The provided resource value is invalid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends SnowballException.BuilderImpl implements Builder {
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidResourceException model) {
            super(model);
            resourceType(model.resourceType);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @JsonProperty("ResourceType")
        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public InvalidResourceException build() {
            return new InvalidResourceException(this);
        }
    }
}
