/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.Ec2AmiResourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON-formatted object that contains the IDs for an Amazon Machine Image (AMI), including the Amazon EC2 AMI ID and
 * the Snowball Edge AMI ID. Each AMI has these two IDs to simplify identifying the AMI in both the AWS Cloud and on the
 * device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ec2AmiResource implements StructuredPojo, ToCopyableBuilder<Ec2AmiResource.Builder, Ec2AmiResource> {
    private final String amiId;

    private final String snowballAmiId;

    private Ec2AmiResource(BuilderImpl builder) {
        this.amiId = builder.amiId;
        this.snowballAmiId = builder.snowballAmiId;
    }

    /**
     * <p>
     * The ID of the AMI in Amazon EC2.
     * </p>
     * 
     * @return The ID of the AMI in Amazon EC2.
     */
    public String amiId() {
        return amiId;
    }

    /**
     * <p>
     * The ID of the AMI on the Snowball Edge device.
     * </p>
     * 
     * @return The ID of the AMI on the Snowball Edge device.
     */
    public String snowballAmiId() {
        return snowballAmiId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amiId());
        hashCode = 31 * hashCode + Objects.hashCode(snowballAmiId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2AmiResource)) {
            return false;
        }
        Ec2AmiResource other = (Ec2AmiResource) obj;
        return Objects.equals(amiId(), other.amiId()) && Objects.equals(snowballAmiId(), other.snowballAmiId());
    }

    @Override
    public String toString() {
        return ToString.builder("Ec2AmiResource").add("AmiId", amiId()).add("SnowballAmiId", snowballAmiId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmiId":
            return Optional.ofNullable(clazz.cast(amiId()));
        case "SnowballAmiId":
            return Optional.ofNullable(clazz.cast(snowballAmiId()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        Ec2AmiResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Ec2AmiResource> {
        /**
         * <p>
         * The ID of the AMI in Amazon EC2.
         * </p>
         * 
         * @param amiId
         *        The ID of the AMI in Amazon EC2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiId(String amiId);

        /**
         * <p>
         * The ID of the AMI on the Snowball Edge device.
         * </p>
         * 
         * @param snowballAmiId
         *        The ID of the AMI on the Snowball Edge device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snowballAmiId(String snowballAmiId);
    }

    static final class BuilderImpl implements Builder {
        private String amiId;

        private String snowballAmiId;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2AmiResource model) {
            amiId(model.amiId);
            snowballAmiId(model.snowballAmiId);
        }

        public final String getAmiId() {
            return amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        public final String getSnowballAmiId() {
            return snowballAmiId;
        }

        @Override
        public final Builder snowballAmiId(String snowballAmiId) {
            this.snowballAmiId = snowballAmiId;
            return this;
        }

        public final void setSnowballAmiId(String snowballAmiId) {
            this.snowballAmiId = snowballAmiId;
        }

        @Override
        public Ec2AmiResource build() {
            return new Ec2AmiResource(this);
        }
    }
}
