/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.CompatibleImageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON-formatted object that describes a compatible Amazon Machine Image (AMI), including the ID and name for a
 * Snowball Edge AMI. This AMI is compatible with the device's physical hardware requirements, and it should be able to
 * be run in an SBE1 instance on the device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompatibleImage implements StructuredPojo, ToCopyableBuilder<CompatibleImage.Builder, CompatibleImage> {
    private final String amiId;

    private final String name;

    private CompatibleImage(BuilderImpl builder) {
        this.amiId = builder.amiId;
        this.name = builder.name;
    }

    /**
     * <p>
     * The unique identifier for an individual Snowball Edge AMI.
     * </p>
     * 
     * @return The unique identifier for an individual Snowball Edge AMI.
     */
    public String amiId() {
        return amiId;
    }

    /**
     * <p>
     * The optional name of a compatible image.
     * </p>
     * 
     * @return The optional name of a compatible image.
     */
    public String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amiId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompatibleImage)) {
            return false;
        }
        CompatibleImage other = (CompatibleImage) obj;
        return Objects.equals(amiId(), other.amiId()) && Objects.equals(name(), other.name());
    }

    @Override
    public String toString() {
        return ToString.builder("CompatibleImage").add("AmiId", amiId()).add("Name", name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmiId":
            return Optional.ofNullable(clazz.cast(amiId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CompatibleImageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CompatibleImage> {
        /**
         * <p>
         * The unique identifier for an individual Snowball Edge AMI.
         * </p>
         * 
         * @param amiId
         *        The unique identifier for an individual Snowball Edge AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiId(String amiId);

        /**
         * <p>
         * The optional name of a compatible image.
         * </p>
         * 
         * @param name
         *        The optional name of a compatible image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String amiId;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CompatibleImage model) {
            amiId(model.amiId);
            name(model.name);
        }

        public final String getAmiId() {
            return amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public CompatibleImage build() {
            return new CompatibleImage(this);
        }
    }
}
