/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServerType {
    VIRTUAL_MACHINE("VIRTUAL_MACHINE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServerType> VALUE_MAP;
    private final String value;

    private ServerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServerType> knownValues() {
        EnumSet<ServerType> knownValues = EnumSet.allOf(ServerType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServerType.class, ServerType::toString);
    }
}

