/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.simspaceweaver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSimulationRequest extends SimSpaceWeaverRequest implements
        ToCopyableBuilder<StartSimulationRequest.Builder, StartSimulationRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartSimulationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(StartSimulationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> MAXIMUM_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaximumDuration").getter(getter(StartSimulationRequest::maximumDuration))
            .setter(setter(Builder::maximumDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumDuration").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(StartSimulationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(StartSimulationRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<S3Location> SCHEMA_S3_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("SchemaS3Location").getter(getter(StartSimulationRequest::schemaS3Location))
            .setter(setter(Builder::schemaS3Location)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaS3Location").build()).build();

    private static final SdkField<S3Location> SNAPSHOT_S3_LOCATION_FIELD = SdkField
            .<S3Location> builder(MarshallingType.SDK_POJO).memberName("SnapshotS3Location")
            .getter(getter(StartSimulationRequest::snapshotS3Location)).setter(setter(Builder::snapshotS3Location))
            .constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotS3Location").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(StartSimulationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DESCRIPTION_FIELD, MAXIMUM_DURATION_FIELD, NAME_FIELD, ROLE_ARN_FIELD, SCHEMA_S3_LOCATION_FIELD,
            SNAPSHOT_S3_LOCATION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String description;

    private final String maximumDuration;

    private final String name;

    private final String roleArn;

    private final S3Location schemaS3Location;

    private final S3Location snapshotS3Location;

    private final Map<String, String> tags;

    private StartSimulationRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.maximumDuration = builder.maximumDuration;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.schemaS3Location = builder.schemaS3Location;
        this.snapshotS3Location = builder.snapshotS3Location;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A value that you provide to ensure that repeated calls to this API operation using the same parameters complete
     * only once. A <code>ClientToken</code> is also known as an <i>idempotency token</i>. A <code>ClientToken</code>
     * expires after 24 hours.
     * </p>
     * 
     * @return A value that you provide to ensure that repeated calls to this API operation using the same parameters
     *         complete only once. A <code>ClientToken</code> is also known as an <i>idempotency token</i>. A
     *         <code>ClientToken</code> expires after 24 hours.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The description of the simulation.
     * </p>
     * 
     * @return The description of the simulation.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The maximum running time of the simulation, specified as a number of minutes (m or M), hours (h or H), or days (d
     * or D). The simulation stops when it reaches this limit. The maximum value is <code>14D</code>, or its equivalent
     * in the other units. The default value is <code>14D</code>. A value equivalent to <code>0</code> makes the
     * simulation immediately transition to <code>Stopping</code> as soon as it reaches <code>Started</code>.
     * </p>
     * 
     * @return The maximum running time of the simulation, specified as a number of minutes (m or M), hours (h or H), or
     *         days (d or D). The simulation stops when it reaches this limit. The maximum value is <code>14D</code>, or
     *         its equivalent in the other units. The default value is <code>14D</code>. A value equivalent to
     *         <code>0</code> makes the simulation immediately transition to <code>Stopping</code> as soon as it reaches
     *         <code>Started</code>.
     */
    public final String maximumDuration() {
        return maximumDuration;
    }

    /**
     * <p>
     * The name of the simulation.
     * </p>
     * 
     * @return The name of the simulation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that the simulation assumes to
     * perform actions. For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>. For more information about IAM roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>Identity and Access
     * Management User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that the simulation
     *         assumes to perform actions. For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i>. For more information about IAM roles, see
     *         <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>Identity
     *         and Access Management User Guide</i>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The location of the simulation schema in Amazon Simple Storage Service (Amazon S3). For more information about
     * Amazon S3, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html"> <i>Amazon Simple
     * Storage Service User Guide</i> </a>.
     * </p>
     * <p>
     * Provide a <code>SchemaS3Location</code> to start your simulation from a schema.
     * </p>
     * <p>
     * If you provide a <code>SchemaS3Location</code> then you can't provide a <code>SnapshotS3Location</code>.
     * </p>
     * 
     * @return The location of the simulation schema in Amazon Simple Storage Service (Amazon S3). For more information
     *         about Amazon S3, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html">
     *         <i>Amazon Simple Storage Service User Guide</i> </a>.</p>
     *         <p>
     *         Provide a <code>SchemaS3Location</code> to start your simulation from a schema.
     *         </p>
     *         <p>
     *         If you provide a <code>SchemaS3Location</code> then you can't provide a <code>SnapshotS3Location</code>.
     */
    public final S3Location schemaS3Location() {
        return schemaS3Location;
    }

    /**
     * <p>
     * The location of the snapshot .zip file in Amazon Simple Storage Service (Amazon S3). For more information about
     * Amazon S3, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html"> <i>Amazon Simple
     * Storage Service User Guide</i> </a>.
     * </p>
     * <p>
     * Provide a <code>SnapshotS3Location</code> to start your simulation from a snapshot.
     * </p>
     * <p>
     * The Amazon S3 bucket must be in the same Amazon Web Services Region as the simulation.
     * </p>
     * <p>
     * If you provide a <code>SnapshotS3Location</code> then you can't provide a <code>SchemaS3Location</code>.
     * </p>
     * 
     * @return The location of the snapshot .zip file in Amazon Simple Storage Service (Amazon S3). For more information
     *         about Amazon S3, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html">
     *         <i>Amazon Simple Storage Service User Guide</i> </a>.</p>
     *         <p>
     *         Provide a <code>SnapshotS3Location</code> to start your simulation from a snapshot.
     *         </p>
     *         <p>
     *         The Amazon S3 bucket must be in the same Amazon Web Services Region as the simulation.
     *         </p>
     *         <p>
     *         If you provide a <code>SnapshotS3Location</code> then you can't provide a <code>SchemaS3Location</code>.
     */
    public final S3Location snapshotS3Location() {
        return snapshotS3Location;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags for the simulation. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
     * in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags for the simulation. For more information about tags, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         resources</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(maximumDuration());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(schemaS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSimulationRequest)) {
            return false;
        }
        StartSimulationRequest other = (StartSimulationRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && Objects.equals(maximumDuration(), other.maximumDuration()) && Objects.equals(name(), other.name())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(schemaS3Location(), other.schemaS3Location())
                && Objects.equals(snapshotS3Location(), other.snapshotS3Location()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSimulationRequest")
                .add("ClientToken", clientToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description()).add("MaximumDuration", maximumDuration()).add("Name", name())
                .add("RoleArn", roleArn()).add("SchemaS3Location", schemaS3Location())
                .add("SnapshotS3Location", snapshotS3Location()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "MaximumDuration":
            return Optional.ofNullable(clazz.cast(maximumDuration()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "SchemaS3Location":
            return Optional.ofNullable(clazz.cast(schemaS3Location()));
        case "SnapshotS3Location":
            return Optional.ofNullable(clazz.cast(snapshotS3Location()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("MaximumDuration", MAXIMUM_DURATION_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("SchemaS3Location", SCHEMA_S3_LOCATION_FIELD);
        map.put("SnapshotS3Location", SNAPSHOT_S3_LOCATION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartSimulationRequest, T> g) {
        return obj -> g.apply((StartSimulationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SimSpaceWeaverRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartSimulationRequest> {
        /**
         * <p>
         * A value that you provide to ensure that repeated calls to this API operation using the same parameters
         * complete only once. A <code>ClientToken</code> is also known as an <i>idempotency token</i>. A
         * <code>ClientToken</code> expires after 24 hours.
         * </p>
         * 
         * @param clientToken
         *        A value that you provide to ensure that repeated calls to this API operation using the same parameters
         *        complete only once. A <code>ClientToken</code> is also known as an <i>idempotency token</i>. A
         *        <code>ClientToken</code> expires after 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The description of the simulation.
         * </p>
         * 
         * @param description
         *        The description of the simulation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The maximum running time of the simulation, specified as a number of minutes (m or M), hours (h or H), or
         * days (d or D). The simulation stops when it reaches this limit. The maximum value is <code>14D</code>, or its
         * equivalent in the other units. The default value is <code>14D</code>. A value equivalent to <code>0</code>
         * makes the simulation immediately transition to <code>Stopping</code> as soon as it reaches
         * <code>Started</code>.
         * </p>
         * 
         * @param maximumDuration
         *        The maximum running time of the simulation, specified as a number of minutes (m or M), hours (h or H),
         *        or days (d or D). The simulation stops when it reaches this limit. The maximum value is
         *        <code>14D</code>, or its equivalent in the other units. The default value is <code>14D</code>. A value
         *        equivalent to <code>0</code> makes the simulation immediately transition to <code>Stopping</code> as
         *        soon as it reaches <code>Started</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumDuration(String maximumDuration);

        /**
         * <p>
         * The name of the simulation.
         * </p>
         * 
         * @param name
         *        The name of the simulation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that the simulation assumes
         * to perform actions. For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>. For more information about IAM roles, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>Identity and
         * Access Management User Guide</i>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that the simulation
         *        assumes to perform actions. For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>. For more information about IAM
         *        roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in
         *        the <i>Identity and Access Management User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The location of the simulation schema in Amazon Simple Storage Service (Amazon S3). For more information
         * about Amazon S3, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html">
         * <i>Amazon Simple Storage Service User Guide</i> </a>.
         * </p>
         * <p>
         * Provide a <code>SchemaS3Location</code> to start your simulation from a schema.
         * </p>
         * <p>
         * If you provide a <code>SchemaS3Location</code> then you can't provide a <code>SnapshotS3Location</code>.
         * </p>
         * 
         * @param schemaS3Location
         *        The location of the simulation schema in Amazon Simple Storage Service (Amazon S3). For more
         *        information about Amazon S3, see the <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html"> <i>Amazon Simple Storage
         *        Service User Guide</i> </a>.</p>
         *        <p>
         *        Provide a <code>SchemaS3Location</code> to start your simulation from a schema.
         *        </p>
         *        <p>
         *        If you provide a <code>SchemaS3Location</code> then you can't provide a
         *        <code>SnapshotS3Location</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaS3Location(S3Location schemaS3Location);

        /**
         * <p>
         * The location of the simulation schema in Amazon Simple Storage Service (Amazon S3). For more information
         * about Amazon S3, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html">
         * <i>Amazon Simple Storage Service User Guide</i> </a>.
         * </p>
         * <p>
         * Provide a <code>SchemaS3Location</code> to start your simulation from a schema.
         * </p>
         * <p>
         * If you provide a <code>SchemaS3Location</code> then you can't provide a <code>SnapshotS3Location</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #schemaS3Location(S3Location)}.
         * 
         * @param schemaS3Location
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaS3Location(S3Location)
         */
        default Builder schemaS3Location(Consumer<S3Location.Builder> schemaS3Location) {
            return schemaS3Location(S3Location.builder().applyMutation(schemaS3Location).build());
        }

        /**
         * <p>
         * The location of the snapshot .zip file in Amazon Simple Storage Service (Amazon S3). For more information
         * about Amazon S3, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html">
         * <i>Amazon Simple Storage Service User Guide</i> </a>.
         * </p>
         * <p>
         * Provide a <code>SnapshotS3Location</code> to start your simulation from a snapshot.
         * </p>
         * <p>
         * The Amazon S3 bucket must be in the same Amazon Web Services Region as the simulation.
         * </p>
         * <p>
         * If you provide a <code>SnapshotS3Location</code> then you can't provide a <code>SchemaS3Location</code>.
         * </p>
         * 
         * @param snapshotS3Location
         *        The location of the snapshot .zip file in Amazon Simple Storage Service (Amazon S3). For more
         *        information about Amazon S3, see the <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html"> <i>Amazon Simple Storage
         *        Service User Guide</i> </a>.</p>
         *        <p>
         *        Provide a <code>SnapshotS3Location</code> to start your simulation from a snapshot.
         *        </p>
         *        <p>
         *        The Amazon S3 bucket must be in the same Amazon Web Services Region as the simulation.
         *        </p>
         *        <p>
         *        If you provide a <code>SnapshotS3Location</code> then you can't provide a
         *        <code>SchemaS3Location</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotS3Location(S3Location snapshotS3Location);

        /**
         * <p>
         * The location of the snapshot .zip file in Amazon Simple Storage Service (Amazon S3). For more information
         * about Amazon S3, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html">
         * <i>Amazon Simple Storage Service User Guide</i> </a>.
         * </p>
         * <p>
         * Provide a <code>SnapshotS3Location</code> to start your simulation from a snapshot.
         * </p>
         * <p>
         * The Amazon S3 bucket must be in the same Amazon Web Services Region as the simulation.
         * </p>
         * <p>
         * If you provide a <code>SnapshotS3Location</code> then you can't provide a <code>SchemaS3Location</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #snapshotS3Location(S3Location)}.
         * 
         * @param snapshotS3Location
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshotS3Location(S3Location)
         */
        default Builder snapshotS3Location(Consumer<S3Location.Builder> snapshotS3Location) {
            return snapshotS3Location(S3Location.builder().applyMutation(snapshotS3Location).build());
        }

        /**
         * <p>
         * A list of tags for the simulation. For more information about tags, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param tags
         *        A list of tags for the simulation. For more information about tags, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SimSpaceWeaverRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String description;

        private String maximumDuration;

        private String name;

        private String roleArn;

        private S3Location schemaS3Location;

        private S3Location snapshotS3Location;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartSimulationRequest model) {
            super(model);
            clientToken(model.clientToken);
            description(model.description);
            maximumDuration(model.maximumDuration);
            name(model.name);
            roleArn(model.roleArn);
            schemaS3Location(model.schemaS3Location);
            snapshotS3Location(model.snapshotS3Location);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getMaximumDuration() {
            return maximumDuration;
        }

        public final void setMaximumDuration(String maximumDuration) {
            this.maximumDuration = maximumDuration;
        }

        @Override
        public final Builder maximumDuration(String maximumDuration) {
            this.maximumDuration = maximumDuration;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final S3Location.Builder getSchemaS3Location() {
            return schemaS3Location != null ? schemaS3Location.toBuilder() : null;
        }

        public final void setSchemaS3Location(S3Location.BuilderImpl schemaS3Location) {
            this.schemaS3Location = schemaS3Location != null ? schemaS3Location.build() : null;
        }

        @Override
        public final Builder schemaS3Location(S3Location schemaS3Location) {
            this.schemaS3Location = schemaS3Location;
            return this;
        }

        public final S3Location.Builder getSnapshotS3Location() {
            return snapshotS3Location != null ? snapshotS3Location.toBuilder() : null;
        }

        public final void setSnapshotS3Location(S3Location.BuilderImpl snapshotS3Location) {
            this.snapshotS3Location = snapshotS3Location != null ? snapshotS3Location.build() : null;
        }

        @Override
        public final Builder snapshotS3Location(S3Location snapshotS3Location) {
            this.snapshotS3Location = snapshotS3Location;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSimulationRequest build() {
            return new StartSimulationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
