/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.simspaceweaver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Status information about the simulation clock.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SimulationClock implements SdkPojo, Serializable, ToCopyableBuilder<SimulationClock.Builder, SimulationClock> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(SimulationClock::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> TARGET_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetStatus").getter(getter(SimulationClock::targetStatusAsString))
            .setter(setter(Builder::targetStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            TARGET_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String targetStatus;

    private SimulationClock(BuilderImpl builder) {
        this.status = builder.status;
        this.targetStatus = builder.targetStatus;
    }

    /**
     * <p>
     * The current status of the simulation clock.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ClockStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the simulation clock.
     * @see ClockStatus
     */
    public final ClockStatus status() {
        return ClockStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the simulation clock.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ClockStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the simulation clock.
     * @see ClockStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The desired status of the simulation clock.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetStatus} will
     * return {@link ClockTargetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetStatusAsString}.
     * </p>
     * 
     * @return The desired status of the simulation clock.
     * @see ClockTargetStatus
     */
    public final ClockTargetStatus targetStatus() {
        return ClockTargetStatus.fromValue(targetStatus);
    }

    /**
     * <p>
     * The desired status of the simulation clock.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetStatus} will
     * return {@link ClockTargetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetStatusAsString}.
     * </p>
     * 
     * @return The desired status of the simulation clock.
     * @see ClockTargetStatus
     */
    public final String targetStatusAsString() {
        return targetStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulationClock)) {
            return false;
        }
        SimulationClock other = (SimulationClock) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(targetStatusAsString(), other.targetStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SimulationClock").add("Status", statusAsString()).add("TargetStatus", targetStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "TargetStatus":
            return Optional.ofNullable(clazz.cast(targetStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("TargetStatus", TARGET_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SimulationClock, T> g) {
        return obj -> g.apply((SimulationClock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SimulationClock> {
        /**
         * <p>
         * The current status of the simulation clock.
         * </p>
         * 
         * @param status
         *        The current status of the simulation clock.
         * @see ClockStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClockStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the simulation clock.
         * </p>
         * 
         * @param status
         *        The current status of the simulation clock.
         * @see ClockStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClockStatus
         */
        Builder status(ClockStatus status);

        /**
         * <p>
         * The desired status of the simulation clock.
         * </p>
         * 
         * @param targetStatus
         *        The desired status of the simulation clock.
         * @see ClockTargetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClockTargetStatus
         */
        Builder targetStatus(String targetStatus);

        /**
         * <p>
         * The desired status of the simulation clock.
         * </p>
         * 
         * @param targetStatus
         *        The desired status of the simulation clock.
         * @see ClockTargetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClockTargetStatus
         */
        Builder targetStatus(ClockTargetStatus targetStatus);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String targetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(SimulationClock model) {
            status(model.status);
            targetStatus(model.targetStatus);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ClockStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTargetStatus() {
            return targetStatus;
        }

        public final void setTargetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
        }

        @Override
        public final Builder targetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
            return this;
        }

        @Override
        public final Builder targetStatus(ClockTargetStatus targetStatus) {
            this.targetStatus(targetStatus == null ? null : targetStatus.toString());
            return this;
        }

        @Override
        public SimulationClock build() {
            return new SimulationClock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
