/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.simspaceweaver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of app instances that run the same executable app code and have the same launch options and commands.
 * </p>
 * <p>
 * For more information about domains, see <a href=
 * "https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_domains"
 * >Key concepts: Domains</a> in the <i>SimSpace Weaver User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Domain implements SdkPojo, Serializable, ToCopyableBuilder<Domain.Builder, Domain> {
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Lifecycle").getter(getter(Domain::lifecycleAsString)).setter(setter(Builder::lifecycle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Domain::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String lifecycle;

    private final String name;

    private Domain(BuilderImpl builder) {
        this.lifecycle = builder.lifecycle;
        this.name = builder.name;
    }

    /**
     * <p>
     * The type of lifecycle management for apps in the domain. Indicates whether apps in this domain are <i>managed</i>
     * (SimSpace Weaver starts and stops the apps) or <i>unmanaged</i> (you must start and stop the apps).
     * </p>
     * <p class="title">
     * <b>Lifecycle types</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PerWorker</code> – Managed: SimSpace Weaver starts one app on each worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BySpatialSubdivision</code> – Managed: SimSpace Weaver starts one app for each spatial partition.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ByRequest</code> – Unmanaged: You use the <code>StartApp</code> API to start the apps and use the
     * <code>StopApp</code> API to stop the apps.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link LifecycleManagementStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lifecycleAsString}.
     * </p>
     * 
     * @return The type of lifecycle management for apps in the domain. Indicates whether apps in this domain are
     *         <i>managed</i> (SimSpace Weaver starts and stops the apps) or <i>unmanaged</i> (you must start and stop
     *         the apps).</p>
     *         <p class="title">
     *         <b>Lifecycle types</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PerWorker</code> – Managed: SimSpace Weaver starts one app on each worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BySpatialSubdivision</code> – Managed: SimSpace Weaver starts one app for each spatial partition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ByRequest</code> – Unmanaged: You use the <code>StartApp</code> API to start the apps and use the
     *         <code>StopApp</code> API to stop the apps.
     *         </p>
     *         </li>
     * @see LifecycleManagementStrategy
     */
    public final LifecycleManagementStrategy lifecycle() {
        return LifecycleManagementStrategy.fromValue(lifecycle);
    }

    /**
     * <p>
     * The type of lifecycle management for apps in the domain. Indicates whether apps in this domain are <i>managed</i>
     * (SimSpace Weaver starts and stops the apps) or <i>unmanaged</i> (you must start and stop the apps).
     * </p>
     * <p class="title">
     * <b>Lifecycle types</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PerWorker</code> – Managed: SimSpace Weaver starts one app on each worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BySpatialSubdivision</code> – Managed: SimSpace Weaver starts one app for each spatial partition.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ByRequest</code> – Unmanaged: You use the <code>StartApp</code> API to start the apps and use the
     * <code>StopApp</code> API to stop the apps.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link LifecycleManagementStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lifecycleAsString}.
     * </p>
     * 
     * @return The type of lifecycle management for apps in the domain. Indicates whether apps in this domain are
     *         <i>managed</i> (SimSpace Weaver starts and stops the apps) or <i>unmanaged</i> (you must start and stop
     *         the apps).</p>
     *         <p class="title">
     *         <b>Lifecycle types</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PerWorker</code> – Managed: SimSpace Weaver starts one app on each worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BySpatialSubdivision</code> – Managed: SimSpace Weaver starts one app for each spatial partition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ByRequest</code> – Unmanaged: You use the <code>StartApp</code> API to start the apps and use the
     *         <code>StopApp</code> API to stop the apps.
     *         </p>
     *         </li>
     * @see LifecycleManagementStrategy
     */
    public final String lifecycleAsString() {
        return lifecycle;
    }

    /**
     * <p>
     * The name of the domain.
     * </p>
     * 
     * @return The name of the domain.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Domain)) {
            return false;
        }
        Domain other = (Domain) obj;
        return Objects.equals(lifecycleAsString(), other.lifecycleAsString()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Domain").add("Lifecycle", lifecycleAsString()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycleAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Lifecycle", LIFECYCLE_FIELD);
        map.put("Name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Domain, T> g) {
        return obj -> g.apply((Domain) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Domain> {
        /**
         * <p>
         * The type of lifecycle management for apps in the domain. Indicates whether apps in this domain are
         * <i>managed</i> (SimSpace Weaver starts and stops the apps) or <i>unmanaged</i> (you must start and stop the
         * apps).
         * </p>
         * <p class="title">
         * <b>Lifecycle types</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PerWorker</code> – Managed: SimSpace Weaver starts one app on each worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BySpatialSubdivision</code> – Managed: SimSpace Weaver starts one app for each spatial partition.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ByRequest</code> – Unmanaged: You use the <code>StartApp</code> API to start the apps and use the
         * <code>StopApp</code> API to stop the apps.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lifecycle
         *        The type of lifecycle management for apps in the domain. Indicates whether apps in this domain are
         *        <i>managed</i> (SimSpace Weaver starts and stops the apps) or <i>unmanaged</i> (you must start and
         *        stop the apps).</p>
         *        <p class="title">
         *        <b>Lifecycle types</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PerWorker</code> – Managed: SimSpace Weaver starts one app on each worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BySpatialSubdivision</code> – Managed: SimSpace Weaver starts one app for each spatial
         *        partition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ByRequest</code> – Unmanaged: You use the <code>StartApp</code> API to start the apps and use
         *        the <code>StopApp</code> API to stop the apps.
         *        </p>
         *        </li>
         * @see LifecycleManagementStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecycleManagementStrategy
         */
        Builder lifecycle(String lifecycle);

        /**
         * <p>
         * The type of lifecycle management for apps in the domain. Indicates whether apps in this domain are
         * <i>managed</i> (SimSpace Weaver starts and stops the apps) or <i>unmanaged</i> (you must start and stop the
         * apps).
         * </p>
         * <p class="title">
         * <b>Lifecycle types</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PerWorker</code> – Managed: SimSpace Weaver starts one app on each worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BySpatialSubdivision</code> – Managed: SimSpace Weaver starts one app for each spatial partition.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ByRequest</code> – Unmanaged: You use the <code>StartApp</code> API to start the apps and use the
         * <code>StopApp</code> API to stop the apps.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lifecycle
         *        The type of lifecycle management for apps in the domain. Indicates whether apps in this domain are
         *        <i>managed</i> (SimSpace Weaver starts and stops the apps) or <i>unmanaged</i> (you must start and
         *        stop the apps).</p>
         *        <p class="title">
         *        <b>Lifecycle types</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PerWorker</code> – Managed: SimSpace Weaver starts one app on each worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BySpatialSubdivision</code> – Managed: SimSpace Weaver starts one app for each spatial
         *        partition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ByRequest</code> – Unmanaged: You use the <code>StartApp</code> API to start the apps and use
         *        the <code>StopApp</code> API to stop the apps.
         *        </p>
         *        </li>
         * @see LifecycleManagementStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecycleManagementStrategy
         */
        Builder lifecycle(LifecycleManagementStrategy lifecycle);

        /**
         * <p>
         * The name of the domain.
         * </p>
         * 
         * @param name
         *        The name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String lifecycle;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(Domain model) {
            lifecycle(model.lifecycle);
            name(model.name);
        }

        public final String getLifecycle() {
            return lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(LifecycleManagementStrategy lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Domain build() {
            return new Domain(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
