/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.simspaceweaver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.simspaceweaver.model.ClockStatus;
import software.amazon.awssdk.services.simspaceweaver.model.ClockTargetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SimulationClock
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SimulationClock> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SimulationClock.getter(SimulationClock::statusAsString)).setter(SimulationClock.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> TARGET_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetStatus").getter(SimulationClock.getter(SimulationClock::targetStatusAsString)).setter(SimulationClock.setter(Builder::targetStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, TARGET_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String targetStatus;

    private SimulationClock(BuilderImpl builder) {
        this.status = builder.status;
        this.targetStatus = builder.targetStatus;
    }

    public final ClockStatus status() {
        return ClockStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ClockTargetStatus targetStatus() {
        return ClockTargetStatus.fromValue(this.targetStatus);
    }

    public final String targetStatusAsString() {
        return this.targetStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulationClock)) {
            return false;
        }
        SimulationClock other = (SimulationClock)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.targetStatusAsString(), other.targetStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SimulationClock").add("Status", (Object)this.statusAsString()).add("TargetStatus", (Object)this.targetStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "TargetStatus": {
                return Optional.ofNullable(clazz.cast(this.targetStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimulationClock, T> g) {
        return obj -> g.apply((SimulationClock)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String targetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(SimulationClock model) {
            this.status(model.status);
            this.targetStatus(model.targetStatus);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ClockStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTargetStatus() {
            return this.targetStatus;
        }

        public final void setTargetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
        }

        @Override
        public final Builder targetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
            return this;
        }

        @Override
        public final Builder targetStatus(ClockTargetStatus targetStatus) {
            this.targetStatus(targetStatus == null ? null : targetStatus.toString());
            return this;
        }

        public SimulationClock build() {
            return new SimulationClock(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SimulationClock> {
        public Builder status(String var1);

        public Builder status(ClockStatus var1);

        public Builder targetStatus(String var1);

        public Builder targetStatus(ClockTargetStatus var1);
    }
}

