/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.simspaceweaver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options that apply when the app starts. These optiAons override default behavior.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchOverrides implements SdkPojo, Serializable, ToCopyableBuilder<LaunchOverrides.Builder, LaunchOverrides> {
    private static final SdkField<List<String>> LAUNCH_COMMANDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LaunchCommands")
            .getter(getter(LaunchOverrides::launchCommands))
            .setter(setter(Builder::launchCommands))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchCommands").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_COMMANDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> launchCommands;

    private LaunchOverrides(BuilderImpl builder) {
        this.launchCommands = builder.launchCommands;
    }

    /**
     * For responses, this returns true if the service returned a value for the LaunchCommands property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLaunchCommands() {
        return launchCommands != null && !(launchCommands instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * App launch commands and command line parameters that override the launch command configured in the simulation
     * schema.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLaunchCommands} method.
     * </p>
     * 
     * @return App launch commands and command line parameters that override the launch command configured in the
     *         simulation schema.
     */
    public final List<String> launchCommands() {
        return launchCommands;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLaunchCommands() ? launchCommands() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchOverrides)) {
            return false;
        }
        LaunchOverrides other = (LaunchOverrides) obj;
        return hasLaunchCommands() == other.hasLaunchCommands() && Objects.equals(launchCommands(), other.launchCommands());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchOverrides").add("LaunchCommands", hasLaunchCommands() ? launchCommands() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchCommands":
            return Optional.ofNullable(clazz.cast(launchCommands()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchOverrides, T> g) {
        return obj -> g.apply((LaunchOverrides) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchOverrides> {
        /**
         * <p>
         * App launch commands and command line parameters that override the launch command configured in the simulation
         * schema.
         * </p>
         * 
         * @param launchCommands
         *        App launch commands and command line parameters that override the launch command configured in the
         *        simulation schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchCommands(Collection<String> launchCommands);

        /**
         * <p>
         * App launch commands and command line parameters that override the launch command configured in the simulation
         * schema.
         * </p>
         * 
         * @param launchCommands
         *        App launch commands and command line parameters that override the launch command configured in the
         *        simulation schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchCommands(String... launchCommands);
    }

    static final class BuilderImpl implements Builder {
        private List<String> launchCommands = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchOverrides model) {
            launchCommands(model.launchCommands);
        }

        public final Collection<String> getLaunchCommands() {
            if (launchCommands instanceof SdkAutoConstructList) {
                return null;
            }
            return launchCommands;
        }

        public final void setLaunchCommands(Collection<String> launchCommands) {
            this.launchCommands = LaunchCommandListCopier.copy(launchCommands);
        }

        @Override
        public final Builder launchCommands(Collection<String> launchCommands) {
            this.launchCommands = LaunchCommandListCopier.copy(launchCommands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchCommands(String... launchCommands) {
            launchCommands(Arrays.asList(launchCommands));
            return this;
        }

        @Override
        public LaunchOverrides build() {
            return new LaunchOverrides(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
